/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.nexaweb.model;

import com.nexaweb.client.ClientSession;
import com.nexaweb.client.netservice.HttpRequest;
import com.nexaweb.client.netservice.HttpResponse;
import com.nexaweb.client.netservice.NetServiceException;
import com.nexaweb.client.netservice.NetServiceListener;
import com.nexaweb.client.netservice.RequestService;
import com.nexaweb.util.UrlUtils;
import com.nexaweb.xml.Document;
import com.nexaweb.xml.ParserException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import jp.co.fujitsu.reffi.client.nexaweb.controller.ParameterMapping;
import jp.co.fujitsu.reffi.client.nexaweb.event.ModelProcessEvent;
import jp.co.fujitsu.reffi.client.nexaweb.model.XalReturnPossibilityModel;
import jp.co.fujitsu.reffi.common.exception.CoreLogicException;

public class HTTPRequestCore
extends XalReturnPossibilityModel
implements NetServiceListener {
    private String requestUrl;
    private String requestMethod = "POST";
    private Map<String, String> urlParameters;
    private boolean renderResponse = true;
    private boolean async = true;
    private boolean dynamicUrl = false;

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public Map<String, String> getUrlParameters() {
        return this.urlParameters;
    }

    public void setUrlParameters(Map<String, String> urlParameters) {
        this.urlParameters = urlParameters;
    }

    public void addUrlParameters(String key, String value) {
        this.getUrlParameters().put(key, value);
    }

    public void removeUrlParameters(String key) {
        this.getUrlParameters().remove(key);
    }

    public boolean isRenderResponse() {
        return this.renderResponse;
    }

    public void setRenderResponse(boolean renderResponse) {
        this.renderResponse = renderResponse;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public boolean isDynamicUrl() {
        return this.dynamicUrl;
    }

    public void setDynamicUrl(boolean dynamicUrl) {
        this.dynamicUrl = dynamicUrl;
    }

    public HTTPRequestCore() {
        this.setUrlParameters(new HashMap<String, String>());
    }

    @Override
    protected void mainproc() throws Exception {
        super.mainproc();
        HttpRequest httpRequest = this.createFormRequest(this.getParameterMapping());
        if (httpRequest == null) {
            throw new CoreLogicException("EFC1001");
        }
        ClientSession clientSession = this.getParameterMapping().getClientSession();
        RequestService requestService = clientSession.getRequestService();
        if (this.isAsync()) {
            this.asyncRequest(httpRequest, requestService);
        } else {
            this.syncRequest(httpRequest, requestService);
        }
    }

    protected void syncRequest(HttpRequest httpRequest, RequestService requestService) throws Exception {
        HttpResponse response = null;
        try {
            response = requestService.retrieve(httpRequest);
            this.requestCompleted(httpRequest.getUri(), response);
        }
        catch (NetServiceException e) {
            throw new CoreLogicException("EFC1002", (Throwable)e);
        }
    }

    protected void asyncRequest(HttpRequest httpRequest, RequestService requestService) throws Exception {
        try {
            requestService.retrieveAsynchronously(httpRequest, (NetServiceListener)this);
        }
        catch (Exception e) {
            throw new CoreLogicException("EFC1003", (Throwable)e);
        }
    }

    private HttpRequest createFormRequest(ParameterMapping parameterMapping) throws Exception {
        String url = this.getRequestUrl();
        if (this.isAsync() && this.isDynamicUrl()) {
            url = this.createDynamicUrl(url);
        }
        String requestMethod = this.getRequestMethod();
        Map<String, String> urlParameters = this.getUrlParameters();
        ClientSession clientsession = parameterMapping.getClientSession();
        HttpRequest httprequest = clientsession.getRequestService().createHttpRequest(url);
        httprequest.setRequestMethod(requestMethod);
        StringBuilder urlParameterBuilder = new StringBuilder();
        if (urlParameters != null) {
            Set<String> set = urlParameters.keySet();
            Iterator<String> it = set.iterator();
            int i = 0;
            while (it.hasNext()) {
                String name = it.next();
                String value = urlParameters.get(name);
                if (i > 0) {
                    urlParameterBuilder.append('&');
                }
                if (name == null) {
                    throw new CoreLogicException("EFC0004");
                }
                urlParameterBuilder.append(UrlUtils.encode((String)name));
                urlParameterBuilder.append('=');
                urlParameterBuilder.append(UrlUtils.encode((String)value));
                ++i;
            }
            if (urlParameterBuilder.length() > 0) {
                String urlParameter = urlParameterBuilder.toString();
                try {
                    if ("POST".equalsIgnoreCase(httprequest.getRequestMethod())) {
                        httprequest.setHeader("Content-Type", "application/x-www-form-urlencoded");
                        httprequest.setContent(urlParameter.getBytes("UTF8"));
                    } else {
                        String uri = httprequest.getUri();
                        int index = uri.indexOf(63);
                        if (index != -1) {
                            if (!uri.endsWith("?") && !uri.endsWith("&")) {
                                uri = uri + "&";
                            }
                            uri = uri + urlParameter;
                        } else {
                            uri = uri + "?" + urlParameter;
                        }
                        httprequest.setUri(uri);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new CoreLogicException("EFC1004", (Throwable)e);
                }
            }
        }
        return httprequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestCompleted(String uri, HttpResponse response) {
        this.setResult(response);
        this.postRequest(uri, response);
        Object result = null;
        try {
            Document document = response.toDocument();
            this.addIdentifierToWindows(document);
            result = document;
            if (this.isRenderResponse()) {
                this.getController().getSession().processXml(document);
            }
        }
        catch (ParserException e) {
            ObjectInputStream objectInputStream = null;
            try {
                objectInputStream = new ObjectInputStream(new ByteArrayInputStream(response.getContent()));
                Object serializedObj = objectInputStream.readObject();
                result = serializedObj;
            }
            catch (IOException ee) {
                result = response.getContent();
            }
            catch (ClassNotFoundException ee) {
                result = response.getContent();
            }
            catch (NullPointerException ee) {
                result = null;
            }
            finally {
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                        objectInputStream = null;
                    }
                    catch (IOException ee) {}
                }
            }
        }
        catch (NullPointerException e) {
            result = null;
        }
        ModelProcessEvent evt = new ModelProcessEvent(this);
        evt.setResult(result);
        this.fireModelSuccess(evt);
        ModelProcessEvent finishedEvent = new ModelProcessEvent(this);
        finishedEvent.setResult(result);
        this.fireModelFinished(finishedEvent);
    }

    private String createDynamicUrl(String url) {
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        sb.append(random.nextInt(10));
        sb.append(random.nextInt(10));
        sb.append(random.nextInt(10));
        sb.append(random.nextInt(10));
        sb.append(random.nextInt(10));
        return "/AsyncReq/" + sb.toString() + url;
    }

    public final void requestFailed(String uri, NetServiceException e) {
        this.postRequestFailed(uri, e);
        Exception ex = this.trap((Exception)((Object)e));
        if (ex != null) {
            ModelProcessEvent evt = new ModelProcessEvent(this);
            evt.setException((Exception)new CoreLogicException("EFC1003", (Throwable)ex));
            this.fireModelFailure(evt);
            ModelProcessEvent finishedEvent = new ModelProcessEvent(this);
            finishedEvent.setException((Exception)new CoreLogicException("EFC1003", (Throwable)ex));
            this.fireModelFinished(finishedEvent);
        }
    }

    public void postRequest(String uri, HttpResponse response) {
    }

    public void postRequestFailed(String uri, NetServiceException e) {
    }
}

