/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.nexaweb.logconsumer;

import com.nexaweb.util.LogConsumer;
import com.nexaweb.util.LogEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import jp.co.fujitsu.reffi.client.nexaweb.controller.ClientConfig;

public abstract class LogConsumerAdapter
implements LogConsumer {
    private String dateFormat = "HH:mm:ss.SSS";

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void init(Object obj) {
        if (obj instanceof ClientConfig) {
            ClientConfig config = (ClientConfig)obj;
            String dateFormat = config.getLogDateFormat();
            this.setDateFormat(dateFormat);
        }
    }

    public void destroy() {
    }

    protected String createLogString(LogEvent evt) {
        StringBuilder sb = new StringBuilder();
        short level = evt.getType();
        long timestamp = evt.getTimestamp();
        String message = "";
        if (evt.getThrowable() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            evt.getThrowable().printStackTrace(pw);
            sw.flush();
            pw.flush();
            try {
                sw.close();
                pw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            message = sw.toString();
        } else {
            message = evt.getMessage();
        }
        String header = this.getHeader(level, timestamp);
        sb.append("[");
        sb.append(header);
        sb.append("]");
        sb.append(" ");
        sb.append(message);
        return sb.toString();
    }

    protected String getHeader(short level, long timestamp) {
        StringBuilder sb = new StringBuilder();
        String levelstring = this.getLevelString(level);
        String datetime = this.getDateTime(timestamp);
        sb.append(levelstring);
        sb.append("-");
        sb.append(datetime);
        return sb.toString();
    }

    protected String getDateTime(long timestamp) {
        Date date = new Date(timestamp);
        SimpleDateFormat sdf = new SimpleDateFormat(this.getDateFormat());
        String datetime = sdf.format(date);
        return datetime;
    }

    protected String getLevelString(short level) {
        String ret;
        switch (level) {
            case 1: {
                ret = "DEBUG";
                break;
            }
            case 2: {
                ret = "INFO";
                break;
            }
            case 4: {
                ret = "ERROR";
                break;
            }
            case 3: {
                ret = "EXCEPTION";
                break;
            }
            default: {
                ret = "UNKNOWN LEVEL";
            }
        }
        return ret;
    }
}

