/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.server.invoker;

import java.util.HashMap;
import java.util.Map;

import jp.co.fujitsu.reffi.common.exception.CoreLogicException;

/**
 * <p>[概 要]</p>
 * Invoker管理クラス。
 * 
 * <p>[詳 細]</p>
 * 
 * <p>[備 考]</p>
 *
 * @author Project Reffi
 */
public final class InvokerFactory {
	/** デフォルトInvokerクラス */
	private static final String DEFAULT_INVOKER_CLASS = "jp.co.fujitsu.reffi.server.invoker.DefaultInvoker";
	/** Invokerキャッシュマップ */
	private static Map<String, Invoker> invokerMap = new HashMap<String, Invoker>();
	
	/**
	 * <p>[概 要]</p>
	 * Invoker取得。
	 * <p>[詳 細]</p>
	 * デフォルトのInvokerを取得します。
	 * <p>[備 考]</p>
	 *
	 * @return デフォルトのInvoker
	 * @throws ReffiServerException Invoker生成に失敗した場合
	 */
	public static Invoker getInvoker() throws CoreLogicException {
		return getInvoker(DEFAULT_INVOKER_CLASS);
	}

	/**
	 * <p>[概 要]</p>
	 * Invoker取得。
	 * <p>[詳 細]</p>
	 * 指定したInvokerクラスを取得します。
	 * <p>[備 考]</p>
	 *
	 * @param invokerClass 取得したいInvokerクラス
	 * @return 指定したInvoker
	 * @throws ReffiServerException Invoker生成に失敗した場合
	 */
	public static Invoker getInvoker(String invokerClass) throws CoreLogicException {
		if (invokerMap.containsKey(invokerClass)) {
			return invokerMap.get(invokerClass);
		}
		try {
			Invoker invoker = (Invoker)Class.forName(invokerClass).newInstance();
			invokerMap.put(invokerClass, invoker);
			return invoker;
		} catch (ClassNotFoundException e) {
			throw new CoreLogicException("EFC9001", e);
		} catch (IllegalAccessException e) {
			throw new CoreLogicException("EFC9001", e);
		} catch (InstantiationException e) {
			throw new CoreLogicException("EFC9001", e);
		} catch (ClassCastException e) {
			throw new CoreLogicException("EFC9001", e);
		}
	}
}
