/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.nexaweb.model;

import java.util.ArrayList;
import java.util.List;
import jp.co.fujitsu.reffi.client.nexaweb.controller.BaseController;
import jp.co.fujitsu.reffi.client.nexaweb.controller.ParameterMapping;
import jp.co.fujitsu.reffi.client.nexaweb.event.ModelProcessEvent;
import jp.co.fujitsu.reffi.client.nexaweb.listener.ModelProcessListener;
import jp.co.fujitsu.reffi.client.nexaweb.model.Model;

public class BaseModel
implements Model {
    private Object result;
    private ParameterMapping parameterMapping;
    private BaseController controller;
    private int executeIndex;
    private List<ModelProcessListener> listenerList = new ArrayList<ModelProcessListener>();
    private int successCount;
    private boolean skip;

    @Override
    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public ParameterMapping getParameterMapping() {
        return this.parameterMapping;
    }

    public void setParameterMapping(ParameterMapping parameterMapping) {
        this.parameterMapping = parameterMapping;
    }

    public BaseController getController() {
        return this.controller;
    }

    public void setController(BaseController controller) {
        this.controller = controller;
    }

    public int getExecuteIndex() {
        return this.executeIndex;
    }

    public void setExecuteIndex(int executeIndex) {
        this.executeIndex = executeIndex;
    }

    public List<ModelProcessListener> getListenerList() {
        return this.listenerList;
    }

    public void setListenerList(List<ModelProcessListener> listenerList) {
        this.listenerList = listenerList;
    }

    @Override
    public void addModelProcessListener(ModelProcessListener listener) {
        this.getListenerList().add(listener);
    }

    public void removeModelProcessListener(ModelProcessListener listener) {
        this.getListenerList().remove(listener);
    }

    public int getSuccessCount() {
        return this.successCount;
    }

    protected int incrementSuccessCount() {
        return this.successCount++;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        try {
            if (!this.preproc()) {
                return;
            }
            this.mainproc();
            this.postproc();
        }
        catch (Exception e) {
            e = this.trap(e);
            if (e != null) {
                ModelProcessEvent evt = new ModelProcessEvent(this);
                evt.setException(e);
                this.fireModelFailure(evt);
            }
        }
        finally {
            this.finalproc();
        }
    }

    protected boolean preproc() throws Exception {
        return true;
    }

    protected void mainproc() throws Exception {
    }

    protected void postproc() throws Exception {
    }

    protected Exception trap(Exception e) {
        return e;
    }

    protected void finalproc() {
    }

    public void fireModelSuccess(ModelProcessEvent evt) {
        this.incrementSuccessCount();
        List<ModelProcessListener> listenerList = this.getListenerList();
        for (ModelProcessListener listener : listenerList) {
            listener.modelSuccess(evt);
        }
    }

    public void fireModelFailure(ModelProcessEvent evt) {
        List<ModelProcessListener> listenerList = this.getListenerList();
        for (ModelProcessListener listener : listenerList) {
            listener.modelFailure(evt);
        }
    }

    public void fireModelFinished(ModelProcessEvent evt) {
        List<ModelProcessListener> listenerList = this.getListenerList();
        for (ModelProcessListener listener : listenerList) {
            listener.modelFinished(evt);
        }
    }
}

