/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.nexaweb.controller;

import com.nexaweb.xml.Document;
import com.nexaweb.xml.Element;
import com.nexaweb.xml.Parser;
import com.nexaweb.xml.ParserFactory;
import com.nexaweb.xml.xpath.XPathFactory;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import jp.co.fujitsu.reffi.client.nexaweb.action.Action;
import jp.co.fujitsu.reffi.client.nexaweb.action.BaseAction;
import jp.co.fujitsu.reffi.client.nexaweb.controller.BaseController;

public class EventBinder {
    private static final int INITIAL_CAPACITY = 2500;
    private Map<String, Map<String, Class<? extends Action>>> bindInfo;
    private BaseController controller;

    public Map<String, Map<String, Class<? extends Action>>> getBindInfo() {
        return this.bindInfo;
    }

    public void setBindInfo(Map<String, Map<String, Class<? extends Action>>> bindInfo) {
        this.bindInfo = bindInfo;
    }

    public BaseController getController() {
        return this.controller;
    }

    public void setController(BaseController controller) {
        this.controller = controller;
    }

    public EventBinder(BaseController controller) {
        this.setBindInfo(new HashMap<String, Map<String, Class<? extends Action>>>(2500));
        this.setController(controller);
    }

    public void addEventBinding(String componentName, String eventType, Class<? extends Action> actionClass) {
        Map<String, Class<? extends Action>> typeMap = null;
        typeMap = this.getBindInfo().containsKey(componentName) ? this.getBindInfo().get(componentName) : new HashMap<String, Class<? extends Action>>();
        typeMap.put(eventType, actionClass);
        this.getBindInfo().put(componentName, typeMap);
    }

    public void addEventBindingImmediately(String componentName, String eventType, Class<? extends Action> actionClass) {
        this.addEventBinding(componentName, eventType, actionClass);
        Document document = this.getController().getSession().getDocumentRegistry().getUiDocument();
        Vector elements = XPathFactory.createXPath((String)("descendant::*[@name='" + componentName + "']")).evaluate(document);
        for (Element element : elements) {
            element.setAttribute(eventType, "mco:controller.handlerFacade()");
        }
    }

    public String[] getEventTypes(String componentName) {
        Map<String, Class<? extends Action>> typeMap = this.getBindInfo().get(componentName);
        if (typeMap == null) {
            return null;
        }
        Set<String> eventTypeSet = typeMap.keySet();
        String[] eventTypes = eventTypeSet.toArray(new String[1]);
        return eventTypes;
    }

    public Class<? extends Action> getActionClass(String componentName, String eventType) {
        Map<String, Class<? extends Action>> typeMap = this.getBindInfo().get(componentName);
        if (typeMap == null) {
            return null;
        }
        Class<? extends Action> actionClass = typeMap.get(eventType);
        return actionClass;
    }

    public void loadConfig(String fileName) {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(fileName);
            Parser parser = ParserFactory.getParser();
            Document document = parser.parseXml((Reader)new InputStreamReader(inputStream, "UTF-8"));
            Vector elements = document.getRootElement().getChildren();
            for (Element element : elements) {
                if ("import".equals(element.getLocalName())) {
                    this.loadConfig(element.getAttribute("resource"));
                    continue;
                }
                if (!"event-mappings".equals(element.getLocalName())) continue;
                this.loadEventConfig(element.getChildren());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void loadEventConfig(Vector<Element> events) throws Exception {
        for (Element eventElement : events) {
            String name = eventElement.getAttribute("name");
            String event = eventElement.getAttribute("event");
            String type = eventElement.getAttribute("type");
            Class<BaseAction> clazz = Class.forName(type).asSubclass(BaseAction.class);
            this.addEventBinding(name, event, clazz);
        }
    }
}

