/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.nexaweb.action;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.fujitsu.reffi.client.nexaweb.action.BaseAction;
import jp.co.fujitsu.reffi.client.nexaweb.controller.ParameterMapping;
import jp.co.fujitsu.reffi.client.nexaweb.model.Model;

public class DispatchAction
extends BaseAction {
    public static final String CLASS = "class";
    public static final String SUCCESS = "success";
    public static final String FAILURE = "failure";
    private CallbackMapping callbackMapping;

    @Override
    public ParameterMapping run(ParameterMapping parameterMapping) throws Exception {
        super.run(parameterMapping);
        this.callbackMapping = new CallbackMapping();
        this.reserveModelsAndCallbackMethod(this.callbackMapping);
        ArrayList<Class<? extends Model>> modelClasses = new ArrayList<Class<? extends Model>>();
        for (int ii = 0; ii < this.callbackMapping.size(); ++ii) {
            Class model = (Class)this.callbackMapping.get(ii).get(CLASS);
            modelClasses.add(model);
        }
        parameterMapping.setModelClasses(modelClasses);
        return parameterMapping;
    }

    protected void reserveModelsAndCallbackMethod(CallbackMapping callbackMapping) {
    }

    @Override
    protected final void reserveModels(List<Class<? extends Model>> models) {
    }

    @Override
    public final void successForward(int index, Model model, Object result) throws Exception {
        String successMethodName = (String)this.callbackMapping.get(index).get(SUCCESS);
        if (successMethodName == null) {
            return;
        }
        Class[] type = new Class[]{Model.class, Object.class};
        Method method = this.getClass().getMethod(successMethodName, type);
        method.invoke((Object)this, model, result);
    }

    @Override
    public final Exception failureForward(int index, Model model, Exception e) {
        String failureMethodName = (String)this.callbackMapping.get(index).get(FAILURE);
        if (failureMethodName == null) {
            return e;
        }
        try {
            Class[] type = new Class[]{Model.class, Exception.class};
            Method method = this.getClass().getMethod(failureMethodName, type);
            method.invoke((Object)this, model, e);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        return e;
    }

    public class CallbackMapping {
        private List<Map<Object, Object>> list = new ArrayList<Map<Object, Object>>();

        public void add(Class<? extends Model> model, String successMethodName, String failureMethodName) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(DispatchAction.CLASS, model);
            map.put(DispatchAction.SUCCESS, successMethodName);
            map.put(DispatchAction.FAILURE, failureMethodName);
            this.list.add(map);
        }

        public int size() {
            return this.list.size();
        }

        public Map<Object, Object> get(int index) {
            return this.list.get(index);
        }
    }
}

