/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.server.flex.factories;

import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import flex.messaging.FlexContext;
import flex.messaging.config.ConfigMap;
import flex.messaging.factories.JavaFactory;
import flex.messaging.factories.JavaFactoryInstance;

/**
 * <p>[概 要]</p>
 * SpringFactoryインスタンスクラス。
 *
 * <p>[詳 細]</p>
 * ファクトリのインスタンスを管理するクラスです。
 *
 * <p>[備 考]</p>
 * 本クラスは現在開発、検証中のため、試験的な提供となります。
 *
 * <p>[環 境]</p>
 * 
 * @author Project Reffi
 */
public class SpringFactoryInstance extends JavaFactoryInstance {
	/**
	 * <p>[概 要]</p>
	 * コンストラクタ
	 *
	 * <p>[詳 細]</p>
	 *
	 * <p>[備 考]</p>
	 *
	 * @param factory ファクトリ
	 * @param id 識別子
	 * @param properties 設定情報
	 */
	public SpringFactoryInstance(JavaFactory factory, String id, ConfigMap properties) {
		super(factory, id, properties);
	}

	@Override
	public Object createInstance() {
		ApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext(FlexContext.getServletContext());
		return context.getBean(getId());
	}

    @Override
    public Class<?> getInstanceClass() {
        if (getSource() == null) {
            return null;
        }
        return super.getInstanceClass();
    }
}
