/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.nexaweb.action;

import com.nexaweb.client.ClientSession;
import com.nexaweb.client.netservice.HttpResponse;
import com.nexaweb.plugin.data.DataFramework;
import com.nexaweb.plugin.data.DataService;
import com.nexaweb.plugin.data.datasource.DataSource;
import com.nexaweb.plugin.data.datasource.DataSourceContainer;
import com.nexaweb.plugin.data.datasource.ObjectDataSource;
import com.nexaweb.plugin.validation.exceptions.ValidationException;
import com.nexaweb.util.Log;
import com.nexaweb.xml.Document;
import com.nexaweb.xml.Element;
import com.nexaweb.xml.ParserException;
import com.nexaweb.xml.xpath.XPathFactory;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import jp.co.fujitsu.reffi.client.nexaweb.action.Action;
import jp.co.fujitsu.reffi.client.nexaweb.controller.BaseController;
import jp.co.fujitsu.reffi.client.nexaweb.controller.ClientConfig;
import jp.co.fujitsu.reffi.client.nexaweb.controller.ParameterMapping;
import jp.co.fujitsu.reffi.client.nexaweb.listener.SubscribeManager;
import jp.co.fujitsu.reffi.client.nexaweb.parser.ElementValueParser;
import jp.co.fujitsu.reffi.client.nexaweb.parser.ElementValues;
import jp.co.fujitsu.reffi.client.nexaweb.validator.CustomValidator;
import jp.co.fujitsu.reffi.client.nexaweb.validator.ValidateError;
import jp.co.fujitsu.reffi.client.nexaweb.validator.ValidateErrors;
import jp.co.fujitsu.reffi.common.exception.CoreLogicException;

public abstract class AbstractAction
implements Action {
    private ParameterMapping parameterMapping;
    private BaseController controller;

    public ParameterMapping getParameterMapping() {
        return this.parameterMapping;
    }

    public void setParameterMapping(ParameterMapping parameterMapping) {
        this.parameterMapping = parameterMapping;
    }

    public BaseController getController() {
        return this.controller;
    }

    public void setController(BaseController controller) {
        this.controller = controller;
    }

    @Override
    public ParameterMapping run(ParameterMapping parameterMapping) throws Exception {
        this.setParameterMapping(parameterMapping);
        parameterMapping.setEventSourceWindow(this.getOwnWindow());
        return parameterMapping;
    }

    protected ValidateErrors validate(List<CustomValidator> validators) throws Exception {
        ValidateErrors validateErrors = new ValidateErrors();
        try {
            for (CustomValidator validator : validators) {
                Element element = validator.getElement();
                this.returnElementStatusBeforeError(element);
            }
            for (CustomValidator validator : validators) {
                validator.setSession(this.getController().getSession());
                if (validator.execute()) continue;
                validateErrors.addError(new ValidateError(validator.getElement(), validator.getErrorMessage(), validator.getHeadWord()));
            }
        }
        catch (ValidationException e) {
            throw new CoreLogicException("EFC0009");
        }
        return validateErrors;
    }

    public void validationFault(ValidateErrors errors) {
        ClientConfig config = this.getController().getClientConfig();
        if (config.isEnableValidationFaultProcessing() && errors.hasError()) {
            StringBuilder messageBuilder = new StringBuilder();
            for (int i = 0; i < errors.size() && i < config.getMaxDisplayCountOnValidationFault(); ++i) {
                ValidateError error = errors.getError(i);
                Element element = error.getElement();
                String headWord = error.getHeadWord();
                String message = error.getMessage();
                if (errors.size() > 1) {
                    messageBuilder.append(i + 1 + ". ");
                }
                messageBuilder.append(headWord);
                messageBuilder.append(" : ");
                messageBuilder.append(message);
                messageBuilder.append(System.getProperty("line.separator"));
                if (!config.isComponentColorAndTipChangeOnValidationFault()) continue;
                this.getController().getErrorElementSnapshot().snap(element);
                element.setAttribute("backgroundColor", config.getComponentColorOnValidationFault());
                element.setAttribute("tooltip", message);
            }
            if (config.isDisplayDialogOnValidationFault()) {
                this.alertDialog("ValidationError", messageBuilder.toString());
            }
        }
    }

    protected boolean returnElementStatusBeforeError(Element element) {
        boolean ret = false;
        Element previousErrorElement = this.getController().getErrorElementSnapshot().fetch(element);
        if (previousErrorElement != null) {
            String backgroundColor = previousErrorElement.getAttribute("backgroundColor");
            if (backgroundColor != null) {
                element.setAttribute("backgroundColor", backgroundColor);
            } else {
                element.removeAttribute("backgroundColor");
            }
            String tooltip = previousErrorElement.getAttribute("tooltip");
            if (tooltip != null) {
                element.setAttribute("tooltip", tooltip);
            } else {
                element.removeAttribute("tooltip");
            }
            ret = true;
        }
        return ret;
    }

    protected Element getElementByNameFromOwnWindow(String name) {
        Element window = this.getOwnWindow();
        Element element = this.getElementByNameFromWindow(window, name);
        return element;
    }

    protected Element getElementByNameFromWindow(Element window, String name) {
        Element element = XPathFactory.createXPath((String)("descendant::*[@name='" + name + "']")).evaluateAsElement((Object)window);
        return element;
    }

    protected Element getOwnWindow() {
        Element element = this.getParameterMapping().getEventSourceElement();
        List<String> windowDefs = this.getController().getClientConfig().getWindowLevelElementDefinition();
        while (!"rootPane".equals(element.getLocalName()) && !windowDefs.contains(element.getLocalName())) {
            element = element.getParent();
        }
        return element;
    }

    protected void closeOwnWindow() {
        Element ownWindowElement = this.getOwnWindow();
        if (!"rootPane".equals(ownWindowElement.getLocalName())) {
            ownWindowElement.getParent().removeChild(ownWindowElement);
        }
    }

    protected Element getParentWindow() {
        Element parentWindow = null;
        String parentId = this.getOwnWindow().getAttribute("parentId");
        if (parentId != null) {
            parentWindow = this.getElementById(parentId);
        }
        return parentWindow;
    }

    protected Vector<Element> getChildWindows() {
        Document document = this.getController().getSession().getDocumentRegistry().getUiDocument();
        String id = this.getOwnWindow().getAttribute("id");
        Vector childWindows = XPathFactory.createXPath((String)("//[@parentId='" + id + "']")).evaluate(document);
        return childWindows;
    }

    protected void closeChildWindows() {
        Vector<Element> childWindows = this.getChildWindows();
        for (Element child : childWindows) {
            child.getParent().removeChild(child);
        }
    }

    protected Vector<Element> getSiblingWindows() {
        Document document = this.getController().getSession().getDocumentRegistry().getUiDocument();
        String parentId = this.getOwnWindow().getAttribute("parentId");
        Vector siblingWindows = XPathFactory.createXPath((String)("//[@parentId='" + parentId + "']")).evaluate(document);
        return siblingWindows;
    }

    protected void closeSiblingWindows() {
        Vector<Element> siblingWindows = this.getSiblingWindows();
        for (Element sibling : siblingWindows) {
            sibling.getParent().removeChild(sibling);
        }
    }

    protected Vector<Element> getAllWindows() {
        Vector<Element> windows = new Vector<Element>();
        Document document = this.getController().getSession().getDocumentRegistry().getUiDocument();
        List<String> windowDefs = this.getController().getClientConfig().getWindowLevelElementDefinition();
        for (String windowDef : windowDefs) {
            Vector allWindows = XPathFactory.createXPath((String)("//" + windowDef)).evaluate(document);
            windows.addAll(allWindows);
        }
        return windows;
    }

    protected Vector<Element> getWindowsByCommunicateId(String communicateId) {
        Document document = this.getController().getSession().getDocumentRegistry().getUiDocument();
        Vector windows = XPathFactory.createXPath((String)("//[@communicateId='" + communicateId + "']")).evaluate(document);
        return windows;
    }

    protected String getOwnWindowCommunicateId() {
        return this.getOwnWindow().getAttribute("communicateId");
    }

    protected void moveToWindowPosition(Element base, Element window) {
        this.moveToWindowPosition(base, window, 0, 0);
    }

    protected void moveToWindowPosition(Element base, Element window, int x_gap, int y_gap) {
        Rectangle baseWindowRect = this.getWindowRect(base);
        int moveTo_x = baseWindowRect.x + x_gap;
        int moveTo_y = baseWindowRect.y + y_gap;
        window.setAttribute("x", String.valueOf(moveTo_x));
        window.setAttribute("y", String.valueOf(moveTo_y));
    }

    protected void moveToWindowRightPosition(Element base, Element window) {
        Rectangle baseWindowRect = this.getWindowRect(base);
        window.setAttribute("x", String.valueOf(baseWindowRect.x + baseWindowRect.width));
        window.setAttribute("y", String.valueOf(baseWindowRect.y));
    }

    protected void moveToWindowBottomPosition(Element base, Element window) {
        Rectangle baseWindowRect = this.getWindowRect(base);
        window.setAttribute("x", String.valueOf(baseWindowRect.x));
        window.setAttribute("y", String.valueOf(baseWindowRect.y + baseWindowRect.height));
    }

    protected Rectangle getWindowRect(Element window) {
        int x = Integer.valueOf(window.getAttribute("x").replaceAll("px", ""));
        int y = Integer.valueOf(window.getAttribute("y").replaceAll("px", ""));
        int width = Integer.valueOf(window.getAttribute("width").replaceAll("px", ""));
        int height = Integer.valueOf(window.getAttribute("height").replaceAll("px", ""));
        return new Rectangle(x, y, width, height);
    }

    protected void cascadeWindows(int x_gap, int y_gap) {
        this.cascadeWindows(this.getAllWindows(), x_gap, y_gap);
    }

    protected void cascadeWindows(Vector<Element> windows, int x_gap, int y_gap) {
        int x = 0;
        int y = 0;
        for (Element window : windows) {
            window.setAttribute("x", String.valueOf(x));
            window.setAttribute("y", String.valueOf(y));
            window.setAttribute("focused", "true");
            x += x_gap;
            y += y_gap;
        }
    }

    protected void tileWindows() {
        this.tileWindows(this.getAllWindows());
    }

    protected void tileWindows(Vector<Element> windows) {
        int windowNum = windows.size();
        double sqrt = Math.sqrt(windowNum);
        int xWindowNum = (int)sqrt;
        int yWindowNum = (int)sqrt;
        double margin = sqrt - (double)((int)sqrt);
        if (margin > 0.0 && margin < 0.5) {
            ++xWindowNum;
        } else if (margin >= 0.5 && margin < 1.0) {
            ++xWindowNum;
            ++yWindowNum;
        }
        Dimension area = null;
        if (this.getController().getSession().getApplet() != null) {
            area = this.getController().getSession().getApplet().getSize();
        } else {
            Window[] ws = Window.getWindows();
            area = ws[0].getSize();
        }
        int windowHeight = area.height / yWindowNum;
        int windowWidth = area.width / xWindowNum;
        for (int y = 0; y < yWindowNum; ++y) {
            int cnt;
            for (int x = 0; x < xWindowNum && (cnt = y * xWindowNum + x) + 1 <= windowNum; ++x) {
                Element window = windows.get(cnt);
                window.setAttribute("x", String.valueOf(x * windowWidth));
                window.setAttribute("y", String.valueOf(y * windowHeight));
                window.setAttribute("width", String.valueOf(windowWidth));
                window.setAttribute("height", String.valueOf(windowHeight));
            }
        }
    }

    protected Element createElement(String localName) {
        Document document = this.getController().getSession().getDocumentRegistry().getUiDocument();
        Element element = document.createElement(localName, "http://openxal.org/ui/java");
        List<String> windowDefs = this.getController().getClientConfig().getWindowLevelElementDefinition();
        if (windowDefs.contains(element.getLocalName())) {
            element.setAttribute("parentId", this.getOwnWindow().getAttribute("id"));
            element.setAttribute("communicateId", UUID.randomUUID().toString());
        }
        return element;
    }

    protected Element getElementById(String id) {
        Document uiDocument = this.getController().getSession().getDocumentRegistry().getUiDocument();
        Element element = uiDocument.getElementById(id);
        return element;
    }

    protected ElementValues getElementValueByNameFromOwnWindow(String name) throws Exception {
        ElementValues values = this.getElementValueByNameFromWindow(this.getOwnWindow(), name);
        return values;
    }

    protected ElementValues getElementValueByNameFromWindow(Element window, String name) throws Exception {
        Element element = this.getElementByNameFromWindow(window, name);
        if (element == null) {
            return null;
        }
        ElementValueParser parser = new ElementValueParser();
        ElementValues values = (ElementValues)parser.parse(element);
        return values;
    }

    protected Object getSerializedHttpResponseContent(HttpResponse response) throws IOException, ClassNotFoundException {
        Object ret = null;
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(response.getContent()));
        ret = objectInputStream.readObject();
        return ret;
    }

    protected ObjectDataSource createElementObjectDataSource(Element element) throws Exception {
        ObjectDataSource ods = new ObjectDataSource();
        String dataProviderId = element.getAttribute("id") + "_dataProvider";
        ods.initialize(dataProviderId, this.getController().getSession(), element);
        ods.setSource((Object)Collections.EMPTY_LIST);
        this.getDataSourceContainer().addDataSource(dataProviderId, (DataSource)ods);
        element.setAttribute("dataProvider", dataProviderId);
        return ods;
    }

    protected ObjectDataSource getElementObjectDataSource(Element element) {
        String dataProviderId = element.getAttribute("id") + "_dataProvider";
        ObjectDataSource dataSource = (ObjectDataSource)this.getDataSourceContainer().getDataSource(dataProviderId);
        return dataSource;
    }

    protected void removeElementObjectDataSource(Element element) {
        String dataProviderId = element.getAttribute("id") + "_dataProvider";
        this.getDataSourceContainer().removeDataSource(dataProviderId);
    }

    protected ObjectDataSource getObjectDataSourceById(String id) {
        return (ObjectDataSource)this.getDataService().getDataSourceContainer().getDataSource(id);
    }

    protected ObjectDataSource getObjectDataSourceByName(String name) {
        ObjectDataSource ret = null;
        Element datasourceElement = this.getElementByNameFromOwnWindow(name);
        String id = datasourceElement.getAttribute("id");
        ret = this.getObjectDataSourceById(id);
        return ret;
    }

    private DataService getDataService() {
        return DataFramework.getDataService((ClientSession)this.getController().getSession());
    }

    private DataSourceContainer getDataSourceContainer() {
        return this.getDataService().getDataSourceContainer();
    }

    public void renderResponseToUI(HttpResponse response) throws ParserException {
        this.getController().getSession().processXml(response);
    }

    public Map<Object, Object> getPermanent() {
        return this.getController().getPermanent();
    }

    public Object getPermanent(Object key) {
        return this.getController().getPermanent().get(key);
    }

    public void addPermanent(Object key, Object value) {
        this.getController().getPermanent().put(key, value);
    }

    public void removePermanent(Object key) {
        this.getController().getPermanent().remove(key);
    }

    protected List<String> getSubscribingTopicNames() {
        return SubscribeManager.instance.getSubscribingTopicNames();
    }

    protected boolean isSubscribing(String topicName) {
        return SubscribeManager.instance.isSubscribing(topicName);
    }

    public Log getClientLogger() {
        return this.getController().getClientLogger();
    }

    protected void alertDialog(String title, String message) {
        this.getController().getSession().getDisplayService().modalAlert(message, title, 1, new String[]{"OK"}, (Object[])new String[]{"OK"});
    }
}

