/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.flex.model.localConnection{

	import flash.events.Event;
	import flash.events.StatusEvent;
	import flash.net.LocalConnection;
	
	import jp.co.fujitsu.reffi.client.flex.error.CoreLogicError;
	import jp.co.fujitsu.reffi.client.flex.events.ModelProcessEvent;
	import jp.co.fujitsu.reffi.client.flex.model.BaseModel;
	
	/**
	 * <p>[概 要]</p>
	 * LocalConnectionReceiverにより接続されているLocalConnectionに、メッセージを送信する機能モデルクラスです.
	 * 
	 * <p>[詳 細]</p>
	 * localConnectionNameプロパティで設定された接続名称へ、argsプロパティで設定された
	 * 引数を送信します。<br>
	 * 
	 * <p>[備 考]</p>
	 * 
	 * @example
	 * 任意のlocalConnectionNameにメッセージを送信する
	 * <listing version="3.0">
        public class LocalConnectionSendAction extends BaseAction {
        
            override protected function reserveModels(models:Array):void {
                models.push(Class(LocalConnectionSenderCore));
            }
    
            override public function nextModel(index:int, prev:ModelProcessEvent, next:BaseModel):Boolean {
                if (index == 0) {
                    var sendArgs:Array = new Array();
                    sendArgs.push("引数1");
                    sendArgs.push("引数2");
                    LocalConnectionSenderCore(next).localConnectionName = "localConnectionDemo";
                    LocalConnectionSenderCore(next).args = sendArgs;
                }
                return true;
            }
        }
	 * </listing>
	 * 
	 * <p>Copyright (c) 2008-2010 FUJITSU Japan All rights reserved.</p>
	 * @author Project Reffi
	 */
	 public class LocalConnectionSenderCore extends BaseModel{

		// LocalConnection名称
		private var _localConnectionName:String;

		// LocalConnection経由で送信する引数
		private var _args:Array = new Array();

		/**
		 * <p>[概 要]</p>
		 * LocalConnection名称です.
		 * 
		 * <p>[詳 細]</p>
		 * 指定したLocalConnection名称が存在しない場合、StatusEventのlevelプロパティが"error"で返却されます。
		 * その場合は、faultHandlerが処理され、コントローラにより空のダイアログが出力されます。
		 * StatusEventは、正常系のイベントのため、エラー文字列が存在しないため空のダイアログとなります。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get localConnectionName():String{
			return this._localConnectionName;
		}
		public function set localConnectionName(localConnectionName:String):void{
			this._localConnectionName = localConnectionName;
		}

		/**
		 * <p>[概 要]</p>
		 * LocalConnection経由で送信する引数です.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get args():Array{
			return this._args;
		}
		public function set args(args:Array):void{
			this._args = args;
		}

		/**
		 * <p>[概 要] </p>
		 * LocalConnectionReceiverCoreに、localConnectionNameで接続しargsプロパティを送信します.
		 * 
		 * <p>[詳 細] </p>
		 * 
		 * <p/>
		 * 
		 */
		override protected function mainProc() : void {
			super.mainProc();

			var localConnection:LocalConnection = new LocalConnection();
			var localConnectionName:String = this._localConnectionName;
			var args:Array = this._args;
			if (localConnectionName == null){
				var error:CoreLogicError = new CoreLogicError("EFC1010");
				throw error;
			}
			localConnection.addEventListener(StatusEvent.STATUS, statusHandler);
			localConnection.send(localConnectionName, "receive", args);
		}
		
		/**
		 * <p>[概 要]</p>
		 * sendメソッド送信時にコールバックされるメソッドです.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param event StatusEvent
		 */
		private function statusHandler(event:StatusEvent):void{
			if (event.level == "status"){
				resultHandler(event);
			} else if(event.level == "error") {
				faultHandler(event);
			}
		}

		/**
		 * <p>[概 要]</p>
		 * sendメソッド送信成功時に呼び出されるメソッドです.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * このメソッドはオーバーライド出来ません。<br/>
		 * メッセージ受信失敗処理を記述する場合はonSuccessメソッドをオーバーライドして下さい。
		 * 
		 * @param event StatusEvent
		 */
		public final function resultHandler(event:StatusEvent):void{
			onSuccess(event);
			
			// モデル終了イベントを生成	
			var modelSuccessEvent : ModelProcessEvent = new ModelProcessEvent(ModelProcessEvent.SUCCESS);
			modelSuccessEvent.cause = event;
			dispatchModelSuccess(modelSuccessEvent);
			
			// モデル完了イベントを生成			
			var modelFinishedEvent : ModelProcessEvent = new ModelProcessEvent(ModelProcessEvent.FINISHED);
			modelFinishedEvent.cause = event;
			dispatchModelFinished(modelFinishedEvent);
		}

		/**
		 * <p>[概 要]</p>
		 * sendメソッド送信成功時オーバーライド用メソッドです.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param event StatusEvent
		 */
		protected function onSuccess(event:StatusEvent):void{
		}
				
		/**
		 * <p>[概 要]</p>
		 * sendメソッド送信失敗時に呼び出されるメソッドです.
		 * 
		 * <p>[詳 細]</p>
		 * StatusEventのlevelプロパティが"error"の場合に呼び出されます。
		 * 
		 * <p>[備 考]</p>
		 * このメソッドはオーバーライド出来ません。<br/>
		 * メッセージ受信失敗処理を記述する場合はonFailureメソッドをオーバーライドして下さい。
		 * 
		 * @param event Event
		 */
		public final function faultHandler(event:Event):void{
			onFailure(event);

			// モデル失敗イベントを生成	
			var modelFailureEvent : ModelProcessEvent = new ModelProcessEvent(ModelProcessEvent.FAILURE);
			modelFailureEvent.cause = event;
			dispatchModelFailure(modelFailureEvent);
		}
		
		/**
		 * <p>[概 要]</p>
		 * sendメソッド送信失敗時オーバーライド用メソッドです.
		 * 
		 * <p>[詳 細]</p>
		 * StatusEventのlevelプロパティが"error"の場合に呼び出されます。
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param event Event
		 */
		protected function onFailure(event:Event):void{
		}
	}
}