/*
 * Decompiled with CFR 0.152.
 */
package jp.recnavi.epg.site;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.recnavi.epg.site.ONTVArea;
import jp.recnavi.epg.site.ONTVDistrict;
import jp.recnavi.epg.site.ONTVPrefecture;
import jp.recnavi.epg.site.ONTVStation;

public class ONTVTest {
    ONTVArea area;
    ONTVDistrict district;
    ONTVPrefecture prefecture;
    ONTVStation station;
    JFrame frame;
    JList districtView;
    JList prefectureView;
    JList stationView;
    Object[] empty = new Object[0];

    public void quit() {
        this.frame.setVisible(false);
        this.frame.dispose();
        System.exit(0);
    }

    void selectDistrict(String districtName) {
        this.station = null;
        this.stationView.setListData(new Object[0]);
        if (districtName == null) {
            this.district = null;
            this.prefecture = null;
            this.prefectureView.setListData(this.empty);
        } else {
            this.district = this.area.getONTVDistrict(districtName);
            Object[] prefectureNames = this.district.getONTVPrefectureNames();
            this.prefectureView.setListData(prefectureNames);
        }
    }

    void selectPrefecture(String prefectureName) {
        if (prefectureName == null) {
            this.prefecture = null;
            this.stationView.setListData(this.empty);
        } else {
            this.prefecture = this.district.getONTVPrefecture(prefectureName);
            Object[] stationNames = this.prefecture.getONTVStationNames();
            this.stationView.setListData(stationNames);
        }
    }

    public void start() {
        this.area = new ONTVArea();
        this.area.update();
        this.districtView = new JList<Object>(this.area.getONTVDistrictNames());
        this.districtView.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ONTVTest.this.selectDistrict((String)ONTVTest.this.districtView.getSelectedValue());
            }
        });
        this.prefectureView = new JList();
        this.prefectureView.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ONTVTest.this.selectPrefecture((String)ONTVTest.this.prefectureView.getSelectedValue());
            }
        });
        this.stationView = new JList();
        JScrollPane districtPane = new JScrollPane();
        districtPane.getViewport().setView(this.districtView);
        JScrollPane prefecturePane = new JScrollPane();
        prefecturePane.getViewport().setView(this.prefectureView);
        JScrollPane stationPane = new JScrollPane();
        stationPane.getViewport().setView(this.stationView);
        JSplitPane areaPane = new JSplitPane(1);
        JSplitPane prefPane = new JSplitPane(1);
        areaPane.setLeftComponent(districtPane);
        areaPane.setRightComponent(prefPane);
        areaPane.setDividerLocation(100);
        prefPane.setLeftComponent(prefecturePane);
        prefPane.setRightComponent(stationPane);
        prefPane.setDividerLocation(100);
        JMenuItem quit = new JMenuItem("\u7d42\u4e86(X)", 88);
        quit.setAccelerator(KeyStroke.getKeyStroke("ctrl Q"));
        quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ONTVTest.this.quit();
            }
        });
        JMenu file = new JMenu("\u30d5\u30a1\u30a4\u30eb(F)");
        file.setMnemonic('f');
        file.add(quit);
        JMenuBar menubar = new JMenuBar();
        menubar.add(file);
        this.frame = new JFrame("ONTVTest");
        this.frame.setJMenuBar(menubar);
        this.frame.getContentPane().add((Component)areaPane, "North");
        this.frame.setSize(400, 400);
        this.frame.setVisible(true);
    }

    public static void main(String[] args) {
        new ONTVTest().start();
    }
}

