/*
 * Decompiled with CFR 0.152.
 */
package jp.recnavi.epg.site;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.recnavi.epg.site.AbstructWebPage;
import jp.recnavi.epg.site.ONTVStation;

class ONTVPrefecture
extends AbstructWebPage {
    String name;
    String code;
    ArrayList<String> stationNames;
    Hashtable<String, ONTVStation> stations;

    ONTVPrefecture(String name, String code) {
        this.name = name;
        this.code = code;
    }

    String getName() {
        return this.name;
    }

    String getCode() {
        return this.code;
    }

    public String getURL() {
        return "http://www.ontvjapan.com/program/gridNormal.php?&tikicd=0" + this.getCode();
    }

    private void add(ONTVStation station) {
        String name = station.getName();
        this.stationNames.add(name);
        this.stations.put(name, station);
    }

    private void setStations(String html) {
        this.stationNames = new ArrayList();
        this.stations = new Hashtable();
        Pattern quickPattern = Pattern.compile("<SELECT\\s*name=\"quick_sel\" .*?</SELECT>", 32);
        Matcher quickMatcher = quickPattern.matcher(html);
        if (quickMatcher.find()) {
            Pattern stationPattern = Pattern.compile("<OPTION VALUE=\"[^#]*#(\\w*)\"\\s*>([^<]*)</OPTION>");
            Matcher stationMatcher = stationPattern.matcher(quickMatcher.group());
            while (stationMatcher.find()) {
                String channel = stationMatcher.group(1);
                String name = stationMatcher.group(2);
                this.add(new ONTVStation(name, channel));
            }
        }
    }

    public Object[] getONTVStationNames() {
        if (this.stationNames == null) {
            this.setStations(this.getHTML());
        }
        return this.stationNames.toArray();
    }
}

