// -*-c++-*-

/*!
  \file debug_server.cpp
  \brief Debug Server class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qt.h>

#include "debug_server.h"

#include "view_holder.h"
#include "debug_client_parser.h"

#include <iostream>

/*-------------------------------------------------------------------*/
/*!

*/
DebugServer::DebugServer( QObject * parent,
                          ViewHolder & view_holder,
                          const int port )

    : QObject( parent )
    , M_view_holder( view_holder )
    , M_socket_device( static_cast< QSocketDevice * >( 0 ) )
    , M_socket_notifier( static_cast< QSocketNotifier * >( 0 ) )
{
    M_socket_device = new QSocketDevice( QSocketDevice::Datagram );
    M_socket_device->setBlocking( false );
    M_socket_device->bind( QHostAddress(), port );

    if ( ! isConnected() )
    {
        std::cerr << "DebugServer. failed to initialize the udp socket"
                  << std::endl;
        return;
    }

    M_socket_notifier = new QSocketNotifier( M_socket_device->socket(),
                                             QSocketNotifier::Read,
                                             this );

    connect( M_socket_notifier, SIGNAL( activated( int ) ),
             this, SLOT( handleReceive( int ) ) );
}

/*-------------------------------------------------------------------*/
/*!
  destructor.
*/
DebugServer::~DebugServer()
{
    if ( isConnected() )
    {
        M_socket_device->close();
    }

    if ( M_socket_device )
    {
        delete M_socket_device;
    }

    if ( M_socket_notifier )
    {
        delete M_socket_notifier;
    }

    //std::cerr << "delete DebugServer" << std::endl;
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
DebugServer::isConnected() const
{
    return ( M_socket_device
             && M_socket_device->socket() != -1 );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugServer::handleReceive( int /*socket*/ )
{
    char buf[8192];

    int n = 0;
    while ( ( n = M_socket_device->readBlock( buf, sizeof( buf ) ) ) > 0 )
    {
        buf[n] = '\0';
        DebugClientParser parser;
        parser.parse( buf, M_view_holder );
    }
}
