// -*-c++-*-

/*!
  \file pass.cpp
  \brief pass object Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 3 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pass.h"

#include <rcsc/common/server_param.h>
#include <rcsc/math_util.h>

using namespace rcsc;

/*-------------------------------------------------------------------*/
/*!

 */
Pass::Pass( const rcsc::GameTime & start_time,
            const int passer,
            const rcsc::Vector2D & start_point )
    : CooperativeAction( start_time,
                         passer,
                         Unum_Unknown,
                         start_point,
                         Vector2D::INVALIDATED,
                         -1 ),
      M_ball_speed( 0.0 )
{

}

/*-------------------------------------------------------------------*/
/*!

 */
Pass::Pass( const GameTime & start_time,
            const int passer,
            const int receiver,
            const rcsc::Vector2D & start_point,
            const rcsc::Vector2D & receive_point,
            const double & ball_speed )
    : CooperativeAction( start_time,
                         passer,
                         receiver,
                         start_point,
                         receive_point,
                         -1 ),
      M_ball_speed( ball_speed )
{
    const double pass_dist = start_point.dist( receive_point );
    double step = calc_length_geom_series( ball_speed,
                                           pass_dist,
                                           ServerParam::i().ballDecay() );
    setDurationStep( static_cast< int >( std::ceil( step ) ) );
}

/*-------------------------------------------------------------------*/
/*!

 */
const char *
Pass::name() const
{
    return "Pass";
}

/*-------------------------------------------------------------------*/
/*!

 */
void
Pass::setReceiver( const int receiver,
                   const rcsc::Vector2D & receive_point,
                   const double & ball_speed )
{
    setLastPlayerUnum( receiver );
    setEndPoint( receive_point );

    const double pass_dist = startPoint().dist( receive_point );
    double step = calc_length_geom_series( ball_speed,
                                           pass_dist,
                                           ServerParam::i().ballDecay() );
    setDurationStep( static_cast< int >( std::ceil( step ) ) );

    M_ball_speed = ball_speed;
}
