// -*-c++-*-

/*!
  \file attacker_positioning_generator.h
  \brief attacker's positioning action generator Header File
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef ATTACKER_POSITIONING_GENERATOR_H
#define ATTACKER_POSITIONING_GENERATOR_H

#include "positioning.h"

#include <rcsc/player/abstract_player_object.h>
#include <rcsc/geom/vector_2d.h>
#include <rcsc/game_time.h>

#include <vector>

namespace rcsc {
class PlayerObject;
class WorldModel;
}

class AttackerPositioningGenerator {
private:
    int M_total_count;

    const rcsc::AbstractPlayerObject * M_passer; //!< estimated passer player
    rcsc::GameTime M_start_time;
    rcsc::Vector2D M_first_point;

    std::vector< CooperativeAction::Ptr > M_actions;


    // private for singleton
    AttackerPositioningGenerator();

    // not used
    AttackerPositioningGenerator( const AttackerPositioningGenerator & );
    AttackerPositioningGenerator & operator=( const AttackerPositioningGenerator & );

public:

    static
    AttackerPositioningGenerator & instance();

    void update( const rcsc::WorldModel & wm );

    const std::vector< Positioning::Ptr > actions()
      {
          return M_actions;
      }

private:

    void clear();

    void updatePasser( const rcsc::WorldModel & wm );
    void createActions( const rcsc::WorldModel & wm );

};

#endif
