// -*-c++-*-

/*!
  \file cooperative_action.h
  \brief cooperative action type Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 3 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef COOPERATIVE_ACTION_H
#define COOPERATIVE_ACTION_H

#include <rcsc/geom/vector_2d.h>
#include <rcsc/game_time.h>
#include <rcsc/types.h>

#include <boost/shared_ptr.hpp>

class CooperativeAction {
public:

    typedef boost::shared_ptr< CooperativeAction > Ptr; //!< pointer type
    typedef boost::shared_ptr< const CooperativeAction > ConstPtr; //!< const pointer type

private:

    rcsc::GameTime M_start_time;

    int M_first_player_unum; //!< first action player's uniform number
    int M_last_player_unum; //!< last acton player's uniform number

    rcsc::Vector2D M_start_point; //!< action start point
    rcsc::Vector2D M_end_point; //!< action end point

    int M_duration_step;

    /*
      double M_ball_speed; //!< first ball speed

      int M_opponent_distance; //!< distance from nearest opponent interceptor
      int M_opponent_step; //!< opponent's fastest step to the end point
     */


protected:

    CooperativeAction();

    CooperativeAction( const rcsc::GameTime & start_time,
                       const int first_player_unum,
                       const int last_palyer_unum,
                       const rcsc::Vector2D & start_point,
                       const rcsc::Vector2D & end_point,
                       const int duration_step );

    void setStartTime( const rcsc::GameTime & start_time );
    void setFirstPlayerUnum( const int unum );
    void setLastPlayerUnum( const int unum );
    void setStartPoint( const rcsc::Vector2D & start_point );
    void setEndPoint( const rcsc::Vector2D & end_point );
    void setDurationStep( const int duration_step );

public:

    virtual
    ~CooperativeAction()
      { }

    virtual
    const char * name() const = 0;


    const rcsc::GameTime & startTime() const
      {
          return M_start_time;
      }

    int firstPlayerUnum() const
      {
          return M_first_player_unum;
      }

    int lastPlayerUnum() const
      {
          return M_last_player_unum;
      }

    const rcsc::Vector2D & startPoint() const
      {
          return M_start_point;
      }

    const rcsc::Vector2D & endPoint() const
      {
          return M_end_point;
      }

    int durationStep() const
      {
          return M_duration_step;
      }

};

#endif
