// -*-c++-*-

/*!
  \file cooperative_action.cpp
  \brief cooperative action type Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 3 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "cooperative_action.h"

using namespace rcsc;

/*-------------------------------------------------------------------*/
/*!

 */
CooperativeAction::CooperativeAction()
    : M_start_time( -1, 0 ),
      M_first_player_unum( Unum_Unknown ),
      M_last_player_unum( Unum_Unknown ),
      M_start_point( rcsc::Vector2D::INVALIDATED ),
      M_end_point( rcsc::Vector2D::INVALIDATED ),
      M_duration_step( -1 )
{

}

/*-------------------------------------------------------------------*/
/*!

 */
CooperativeAction::CooperativeAction( const rcsc::GameTime & start_time,
                                      const int first_player_unum,
                                      const int last_player_unum,
                                      const rcsc::Vector2D & start_point,
                                      const rcsc::Vector2D & end_point,
                                      const int duration_step )
    : M_start_time( start_time ),
      M_first_player_unum( first_player_unum ),
      M_last_player_unum( last_player_unum ),
      M_start_point( start_point ),
      M_end_point( end_point ),
      M_duration_step( duration_step )
{

}

/*-------------------------------------------------------------------*/
/*!

 */
void
CooperativeAction::setStartTime( const rcsc::GameTime & start_time )
{
    M_start_time = start_time;
}

/*-------------------------------------------------------------------*/
/*!

 */
void
CooperativeAction::setFirstPlayerUnum( const int unum )
{
    M_first_player_unum = unum;
}

/*-------------------------------------------------------------------*/
/*!

 */
void
CooperativeAction::setLastPlayerUnum( const int unum )
{
    M_last_player_unum = unum;
}

/*-------------------------------------------------------------------*/
/*!

 */
void
CooperativeAction::setStartPoint( const rcsc::Vector2D & start_point )
{
    M_start_point = start_point;
}

/*-------------------------------------------------------------------*/
/*!

 */
void
CooperativeAction::setEndPoint( const rcsc::Vector2D & end_point )
{
    M_end_point = end_point;
}

/*-------------------------------------------------------------------*/
/*!

 */
void
CooperativeAction::setDurationStep( const int duration_step )
{
    M_duration_step = duration_step;
}
