// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hiroki SHIMORA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#define DEBUG_PRINT

#include "actgen_through_pass.h"
#include "simple_pass_checker.h"
#include "world_model_ext.h"
#include <rcsc/common/logger.h>
#include <rcsc/math_util.h>
#include <utility>

ActGen_ThroughPass::ActGen_ThroughPass()
{
}

ActGen_ThroughPass::~ActGen_ThroughPass()
{
}


// XXX: should unify with bhv_basic_kick.cpp
static
double
s_get_ball_speed_for_pass( const double & distance );

void
ActGen_ThroughPass::addCandidates( std::vector< rcsc::ActionStatePair > * result,
                                   const rcsc::PredictState & state,
                                   const rcsc::WorldModel &,
                                   const std::vector< rcsc::ActionStatePair > &  path ) const
{
#ifdef DEBUG_PRINT
    rcsc::dlog.addText( rcsc::Logger::ACTION,
                        __FILE__": ActGen_ThroughPass::addCandidates()" );
#endif

    static const int VALID_PLAYER_THRESHOLD = 8;

    std::vector<double> offset_candidates_x;

    for ( double d = -2.0; d <= 30.0 + rcsc::EPS; )
    {
        offset_candidates_x.push_back( d );

        if ( path.size() >= 1 )
        {
            d += 10.0;
        }
        else if ( d >= 5.0 + rcsc::EPS )
        {
            d += 2.0;
        }
        else if ( d >= 10.0 + rcsc::EPS )
        {
            d += 5.0;
        }
        else
        {
            d += 1.0;
        }
    }

    std::vector<double> offset_candidates_y;
    offset_candidates_y.push_back( 0.0 );
    offset_candidates_y.push_back( -5.0 );
    offset_candidates_y.push_back( +5.0 );

    const rcsc::AbstractPlayerObject * holder = state.ballHolder();

    //
    // add pass candidates
    //
    const rcsc::SimplePassChecker pass_check;

    const rcsc::PredictState::PlayerCont::const_iterator end = state.allTeammates().end();
    for ( rcsc::PredictState::PlayerCont::const_iterator pl = state.allTeammates().begin();
          pl != end;
          ++pl )
    {
        if ( ! (*pl).valid()
             || (*pl).posCount() > VALID_PLAYER_THRESHOLD
             || (*pl).isGhost()
             || (*pl).unum() == -1 )
        {
            continue;
        }

        if ( (*pl).pos().x < state.offsideLineX() - 10.0 )
        {
            continue;
        }

        rcsc::Vector2D teammate_pos = (*pl).pos();
        if ( (*pl).velCount() == 0 )
        {
            teammate_pos += (*pl).vel() * 2.0;
        }

#ifdef DEBUG_PRINT
        rcsc::dlog.addText( rcsc::Logger::ACTION,
                            __FILE__": checking through pass to player %d",
                            (*pl).unum() );
#endif

        for ( size_t i = 0; i < offset_candidates_x.size(); ++i )
        {
            for ( size_t j = 0; j < offset_candidates_y.size(); ++j )
            {
                rcsc::Vector2D receive_point( state.offsideLineX() + offset_candidates_x[i],
                                              (*pl).pos().y + offset_candidates_y[j] );

                const double ball_dist = ( state.ballPos() - receive_point ).r();
                const double receiver_dist = ( teammate_pos - receive_point ).r();
                const double ball_first_speed = s_get_ball_speed_for_pass( ball_dist );
                double ball_step = rcsc::calc_length_geom_series
                    ( ball_first_speed,
                      ball_dist,
                      rcsc::ServerParam::i().ballDecay() );

                double receiver_step
                    = (*pl).playerTypePtr()->cyclesToReachDistance( receiver_dist );

#ifdef DEBUG_PRINT
                rcsc::dlog.addText( rcsc::Logger::ACTION,
                                    __FILE__": receiver_step = %f, ball_step = %f",
                                    receiver_step, ball_step );
#endif

#if 0
                if ( receiver_step + 3 > ball_step )
#else
                if ( receiver_step + 2 >= ball_step )
#endif
                {
#ifdef DEBUG_PRINT
                    rcsc::dlog.addText( rcsc::Logger::ACTION,
                                        __FILE__": can't receive" );
#endif
                    continue;
                }


                const bool can_pass = pass_check( state, holder, &(*pl), receive_point );

#ifdef DEBUG_PRINT
                rcsc::dlog.addText( rcsc::Logger::ACTION,
                                    __FILE__": pass check = %d",
                                    static_cast<int>( can_pass ) );
#endif

                if ( ! can_pass )
                {
                    continue;
                }

                result->push_back( rcsc::ActionStatePair
                                   ( rcsc::CooperativeAction
                                     ( rcsc::CooperativeAction::ActionType::Pass,
                                       receive_point,
                                       (*pl).unum(),
                                       ball_first_speed,
                                       "through" ),
                                     rcsc::PredictState
                                     ( state, ball_step,
                                       (*pl).unum(), receive_point ) ) );
            }
        }
    }
}


static
double
s_get_ball_speed_for_pass( const double & distance )
{
    if ( distance >= 20.0 )
    {
        return 3.0;
    }
    else if ( distance >= 8.0 )
    {
        return 2.5;
    }
    else if ( distance >= 5.0 )
    {
        return 1.8;
    }
    else
    {
        return 1.5;
    }
}
