// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hiroki SHIMORA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef ACTGEN_RECURSIVE_LEVEL_FILTER_H
#define ACTGEN_RECURSIVE_LEVEL_FILTER_H

#include "cooperative_action_candidate_generator.h"
#include <boost/scoped_ptr.hpp>
#include <vector>

class ActGen_RecursiveLevelFilter
    : public rcsc::CooperativeActionCandidateGenerator {

private:
    const boost::scoped_ptr< const rcsc::CooperativeActionCandidateGenerator > M_generator;
    const unsigned int M_threshold_level;

public:
    ActGen_RecursiveLevelFilter( const rcsc::CooperativeActionCandidateGenerator * generator,
                                 unsigned int threshold_level )
        : M_generator( generator )
        , M_threshold_level( threshold_level )
      { }

    void addCandidates( std::vector< rcsc::ActionStatePair > * result,
                        const rcsc::PredictState & state,
                        const rcsc::WorldModel & current_wm,
                        const std::vector< rcsc::ActionStatePair > & path ) const
      {
          if ( path.size() < M_threshold_level )
          {
              M_generator->addCandidates( result, state, current_wm, path );
          }
      }
};

#endif
