// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hiroki SHIMORA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef ACTGEN_BALL_POS_GEOMETRY_FILTER_H
#define ACTGEN_BALL_POS_GEOMETRY_FILTER_H

#include "cooperative_action_candidate_generator.h"
#include <rcsc/geom/region_2d.h>
#include <boost/scoped_ptr.hpp>
#include <boost/shared_ptr.hpp>
#include <vector>

namespace rcsc {

class ActGen_BallPosGeometryFilter
    : public rcsc::CooperativeActionCandidateGenerator {

private:
    const boost::shared_ptr< const rcsc::CooperativeActionCandidateGenerator > M_generator;
    const boost::scoped_ptr< const rcsc::Region2D > M_region;

//  check segment its edges are ball pos of states crosses the region
//  if this value is false, checks ball position of state only
//  bool M_check_ball_transition_segments;

//  allow first transition when first ball position is not in region
//  bool M_ignore_first_transition;

public:
    ActGen_BallPosGeometryFilter( rcsc::CooperativeActionCandidateGenerator * generator,
                                  const rcsc::Region2D * allowed_region )
        : M_generator( generator )
        , M_region( allowed_region )
      { }

    ActGen_BallPosGeometryFilter( const boost::shared_ptr< const CooperativeActionCandidateGenerator > & generator,
                                  const rcsc::Region2D * allowed_region )
        : M_generator( generator )
        , M_region( allowed_region )
      { }

    void addCandidates( std::vector< rcsc::ActionStatePair > * result,
                        const rcsc::PredictState & state,
                        const rcsc::WorldModel & current_wm,
                        const std::vector< rcsc::ActionStatePair > & path ) const
      {
          std::vector< rcsc::ActionStatePair > result_candidates;

          M_generator->addCandidates( &result_candidates, state, current_wm, path );

          for ( size_t i = 0; i < result_candidates.size(); ++i )
          {
              if ( M_region->contains( result_candidates[i].state.ballPos() ) )
              {
                  result->push_back( result_candidates[i] );
              }
          }
      }
};

}

#endif
