// -*-c++-*-

/*!
  \file home_positions.cpp
  \brief home position holder Source File
*/

/*
 *Copyright:

  Copyright (C) Hidehisa AKIYAMA

  This code is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  This code is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this code; see the file COPYING.  If not, write to
  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "home_positions.h"

#include <rcsc/formation/formation.h>
#include <rcsc/game_time.h>

/*-------------------------------------------------------------------*/
/*!

*/
HomePositions &
HomePositions::instance()
{
    static HomePositions s_instance;
    return s_instance;
}

/*-------------------------------------------------------------------*/
/*!

*/
HomePositions::HomePositions()
    : M_number( 0 )
{
    M_positions.reserve( 11 );
    M_side_types.reserve( 11 );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
HomePositions::update( const int my_number,
                       const rcsc::Formation & formation,
                       const rcsc::Vector2D & focus_point,
                       const rcsc::GameTime & current )
{
    static rcsc::GameTime s_last_update_time( -1, 0 );

    if ( s_last_update_time == current )
    {
        return;
    }

    s_last_update_time = current;

    M_number = my_number;

    M_positions.clear();
    formation.getPositions( focus_point, M_positions );

    M_side_types.clear();
    for ( int unum = 1; unum < 11; ++unum )
    {
        if ( formation.isSideType( unum ) )
        {
            M_side_types.push_back( SIDE );
        }
        else if ( formation.isSynmetryType( unum ) )
        {
            M_side_types.push_back( MIRROR );
        }
        else
        {
            M_side_types.push_back( CENTER );
        }
    }
}
