// -*-c++-*-

/*!
  \file view_config_dialog.h
  \brief View Config Dialog class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_QT3_VIEW_CONFIG_DIALOG_H
#define SOCCERWINDOW2_QT3_VIEW_CONFIG_DIALOG_H

#include <qtabdialog.h>

class QCheckBox;
class QComboBox;
class QLabel;
class QLineEdit;
class QPushButton;
class QRadioButton;
class QSlider;
class QSpinBox;

class MainData;
class ViewConfig;


//! field canvas configuration dialog
class ViewConfigDialog
    : public QTabDialog {

    Q_OBJECT

private:

    const MainData & M_main_data;
    ViewConfig & M_view_config;

    // zoom control
    //    QCheckBox * M_score_board_auto_fit_cb;
    QSlider * M_scale_slider;
    QLineEdit * M_scale_text;

    // object size
    QCheckBox * M_enlarge_cb;
    QLineEdit * M_ball_size_text;
    QLineEdit * M_player_size_text;

    // canvas size control
    QLineEdit * M_canvas_width_text;
    QLineEdit * M_canvas_height_text;

    // reverse mode control
    QCheckBox * M_reverse_side_cb;
    QCheckBox * M_player_reverse_draw_cb;

    // player detail control
    QCheckBox * M_player_number_cb;
    QCheckBox * M_hetero_number_cb;
    QCheckBox * M_stamina_cb;
    QCheckBox * M_view_cone_cb;
    QCheckBox * M_body_shadow_cb;
    QCheckBox * M_control_area_cb;

    // show/hide control
    QCheckBox * M_anonymous_mode_cb;
    QCheckBox * M_show_score_board_cb;
    QCheckBox * M_show_team_logo_cb;
    QCheckBox * M_show_ball_cb;
    QCheckBox * M_show_players_cb;
    QCheckBox * M_show_flags_cb;
    QCheckBox * M_show_offside_line_cb;

    // field style
    QRadioButton * M_grass_normal_rb;
    QRadioButton * M_grass_line_rb;
    QRadioButton * M_grass_checker_rb;

    QCheckBox * M_keepaway_mode_cb;

    QCheckBox * M_show_grid_coord_cb;
    QSlider * M_grid_step_slider;
    QLineEdit * M_grid_step_text;

    QComboBox * M_draw_type_choice;

    // cursor
    QCheckBox * M_cursor_hide_cb;

    // computational geometry control
    QCheckBox * M_show_voronoi_cb;
    QCheckBox * M_show_delaunay_cb;
    QComboBox * M_voronoi_choice;

    // focus control
    QRadioButton * M_focus_ball_rb;
    QRadioButton * M_focus_player_rb;
    QRadioButton * M_focus_fix_rb;

    // player selection
    QRadioButton * M_select_all_rb;
    QRadioButton * M_select_left_rb;
    QRadioButton * M_select_right_rb;
    QRadioButton * M_select_fix_rb;
    QRadioButton * M_unselect_rb;

    QComboBox * M_player_choice;

    // trace control
    QLineEdit * M_ball_trace_start;
    QLineEdit * M_ball_trace_end;
    QCheckBox * M_ball_trace_cb;
    QLineEdit * M_player_trace_start;
    QLineEdit * M_player_trace_end;
    QCheckBox * M_player_trace_cb;

    QLineEdit * M_auto_trace_start;
    QSpinBox * M_auto_trace_period;

    // inertia movement control
    QSpinBox * M_ball_future;
    QSpinBox * M_player_future;

public:

    ViewConfigDialog( QWidget * parent,
                      const MainData & main_data,
                      ViewConfig & view_config );


    ~ViewConfigDialog();
private:

    void createWidgets();

    QWidget * createZoomControls( QWidget * parent );
    QWidget * createObjectSizeControls( QWidget * parent );
    QWidget * createCanvasSizeControls( QWidget * parent );
    QWidget * createReverseControls( QWidget * parent );
    QWidget * createPlayersDetailControls( QWidget * parent );
    QWidget * createShowControls( QWidget * parent );
    QWidget * createFieldStyleControls( QWidget * parent );
    QWidget * createMiscControls( QWidget * parent );
    QWidget * createGridStepControls( QWidget * parent );
    QWidget * createCompGeomControls( QWidget * parent );
    QWidget * createFocusControls( QWidget * parent );
    QWidget * createPlayerSelectionControls( QWidget * parent );
    QWidget * createTraceControls( QWidget * parent );
    QWidget * createInertiaMoveControls( QWidget * parent );


protected:

    void showEvent( QShowEvent * event );


private slots:

    // just update this dialog contents
    // no emit
    void updateAll();

    //-----------------------

    // connect to itself
    // emit configured()
    //    void clickScoreBoardAutoFit( bool checked );

    void clickEnlarge( bool checked );
    void slideFieldScale( int value );
    void editFieldScale( const QString & text );

    void clickReverseSide( bool checked );
    void clickPlayerReverseDraw( bool checked );

    void clickShowPlayerNumber( bool checked );
    void clickShowHeteroNumber( bool checked );
    void clickShowStamina( bool checked );
    void clickShowViewCone( bool checked );
    void clickShowBodyShadow( bool checked );
    void clickShowControlArea( bool checked );

    void clickAnonymousMode( bool checked );
    void clickShowScoreBoard( bool checked );
    void clickShowTeamLogo( bool checked );
    void clickShowBall( bool checked );
    void clickShowPlayers( bool checked );
    void clickShowFlags( bool checked );
    void clickShowOffsideLine( bool checked );

    void clickGrassNormal();
    void clickGrassLine();
    void clickGrassChecker();

    void clickKeepawayMode( bool checked );

    void clickShowGridCoord( bool checked );
    void slideGridStep( int value );
    void editGridStep( const QString & text );
    void selectDrawType( int index );

    void clickCursorHide( bool checked );

    void clickShowVoronoiDiagram( bool checked );
    void clickShowDelaunayTrianglation( bool checked );
    void selectCompGeomSide( int index );

    void clickFocusBall();
    void clickFocusPlayer();

    void clickSelectAutoAll();
    void clickSelectAutoLeft();
    void clickSelectAutoRight();
    void clickSelectFix();

    void editBallTraceStart( const QString & text );
    void editBallTraceEnd( const QString & text );
    void clickBallTraceAll();
    void clickAutoBallTrace( bool checked );

    void editPlayerTraceStart( const QString & text );
    void editPlayerTraceEnd( const QString & text );
    void clickPlayerTraceAll();
    void clickAutoPlayerTrace( bool checked );

    void editAutoTraceStart( const QString & text );
    void changeAutoTracePeriod( int value );

    void clickLinePointButton();

    void changeBallFutureCycle( int value );
    void changePlayerFutureCycle( int value );

public slots:

    // just update this dialog contents
    // no emit
    void updateFieldScale();

    // connect to other objects
    // emit configured()
    void zoomIn();
    void zoomOut();
    void unzoom();

    void toggleEnlarge();
    void editBallSize( const QString & text );
    void editPlayerSize( const QString & text );

    void applyCanvasSize();

    void toggleReverseSide();
    void togglePlayerReverseDraw();

    void toggleShowPlayerNumber();
    void toggleShowHeteroNumber();
    void toggleShowStamina();
    void toggleShowViewCone();
    void toggleShowBodyShadow();
    void toggleShowControlArea();

    void toggleAnonymousMode();
    void toggleShowScoreBoard();
    void toggleShowTeamLogo();
    void toggleShowPlayers();
    void toggleShowBall();
    void toggleShowFlags();
    void toggleShowOffsideLine();

    void toggleFocusBall();
    void toggleFocusPlayer();
    void setFocusFix();
    void setFocusPoint( const QPoint & point );

    void toggleSelectAutoAll();
    void toggleSelectAutoLeft();
    void toggleSelectAutoRight();
    void toggleSelectFix();
    void setUnselect();

    // 1-11: left, 12-22: right
    void selectPlayer( int number );
    void choicePlayer( int number );

    void toggleKeepawayMode();

signals:

    void configured();
    void canvasResized( const QSize & size );

};

#endif
