// -*-c++-*-

/*!
  \file player_type_dialog.h
  \brief player type list dialog class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_QT3_PLAYER_TYPE_DIALOG_H
#define SOCCERWINDOW2_QT3_PLAYER_TYPE_DIALOG_H

#include <qdialog.h>

#include <vector>

class QShowEvent;
class QListView;
class QListViewItem;

class MainData;

//! movable objects detail info dialog
class PlayerTypeDialog
    : public QDialog {

    Q_OBJECT

private:

    const MainData & M_main_data;

    QListView * M_player_type_table;
    std::vector< QListViewItem * > M_player_types;

    // not used
    PlayerTypeDialog();
    PlayerTypeDialog( const PlayerTypeDialog & );
    const PlayerTypeDialog & operator=( const PlayerTypeDialog & );

public:
    //! constructor
    PlayerTypeDialog( QWidget * parent,
                      const MainData & data );

    ~PlayerTypeDialog();

private:

    void createTable();
    void createListViewItems();

protected:

    void showEvent( QShowEvent * event );

public slots:

    void updateData();

};

#endif
