// -*-c++-*-

/*!
  \file launcher_dialog.cpp
  \brief Launcher Dialog class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qt.h>

#include "launcher_dialog.h"

#include "app_config.h"

#include <iostream>
#include <cassert>
#include <cstdlib>

const int LauncherDialog::MAX_HISTORY = 10;

/*-------------------------------------------------------------------*/
/*!

*/
LauncherDialog::LauncherDialog( QWidget * parent )
    : QDialog( parent )
{
    assert( parent );

    //this->setWindowTitle( tr( "Image Save" ) ); // qt4
    this->setCaption( tr( "Launcher" ) );

    createControls();

    readSettings();
}

/*-------------------------------------------------------------------*/
/*!

*/
LauncherDialog::~LauncherDialog()
{
    saveSettings();
}

/*-------------------------------------------------------------------*/
/*!

*/
void
LauncherDialog::readSettings()
{
    QSettings settings( QSettings::Ini );
    settings.insertSearchPath( QSettings::Unix,
                               QDir::homeDirPath() );

    settings.beginGroup( "/.soccerwindow2-qt3./LauncherDialog" );

    QString val;

    for ( int i = 0; i < MAX_HISTORY; ++i )
    {
        val = settings.readEntry( QString( "LeftStart%1" ).arg( i ) );
        if ( val.isNull() )
        {
            break;
        }
        M_left_team_commands->insertItem( val );
    }

    for ( int i = 0; i < MAX_HISTORY; ++i )
    {
        val = settings.readEntry( QString( "RightStart%1" ).arg( i ) );
        if ( val.isNull() )
        {
            break;
        }
        M_right_team_commands->insertItem( val );
    }

    settings.endGroup();

}

/*-------------------------------------------------------------------*/
/*!

*/
void
LauncherDialog::saveSettings()
{
    QSettings settings( QSettings::Ini );
    settings.insertSearchPath( QSettings::Unix,
                               QDir::homeDirPath() );

    settings.beginGroup( "/.soccerwindow2-qt3./LauncherDialog" );

    {
        const int count = M_left_team_commands->count();
        for ( int i = 0; i < count; ++i )
        {
            QString name = QString( "LeftStart%1" ).arg( i );
            settings.writeEntry( name, M_left_team_commands->text( i ) );
        }
    }

    {
        const int count = M_right_team_commands->count();
        for ( int i = 0; i < count; ++i )
        {
            QString name = QString( "RightStart%1" ).arg( i );
            settings.writeEntry( name, M_right_team_commands->text( i ) );
        }
    }

    settings.endGroup();
}

/*-------------------------------------------------------------------*/
/*!

*/
void
LauncherDialog::createControls()
{
    QVBoxLayout * layout = new QVBoxLayout( this );
    layout->setMargin( 4 );

    layout->addLayout( createServerControls(), 0 );
    layout->addLayout( createLeftTeamControls(), 0 );
    layout->addLayout( createRightTeamControls(), 0 );

    layout->addSpacing( 2 );

    layout->addLayout( createExecuteControls(), 0 );
}

/*-------------------------------------------------------------------*/
/*!

*/
QLayout *
LauncherDialog::createServerControls()
{
    QHBoxLayout * layout = new QHBoxLayout();

    QHGroupBox * group_box = new QHGroupBox( tr( "rcssserver" ), this );

    //QLabel * label = new QLabel( tr( "Command: " ), group_box );
    //label->setMinimumSize( 80,  this->fontMetrics().height() + 12 );
    //label->setMaximumSize( 100, this->fontMetrics().height() + 12 );

    QString sserver_path = AppConfig::instance().serverPath();

    M_rcssserver_command = new QLineEdit( sserver_path, group_box );
    M_rcssserver_command->setMinimumSize( 160, this->fontMetrics().height() + 12 );
    //M_rcssserver_command->setMaximumSize( 240, this->fontMetrics().height() + 12 );

    QPushButton * execute_btn = new QPushButton( tr( "Start!" ), group_box );
    execute_btn->setMinimumSize( 80, this->fontMetrics().height() + 12 );
    execute_btn->setMaximumSize( 80, this->fontMetrics().height() + 12 );
    execute_btn->setAutoDefault( false );

    connect( execute_btn, SIGNAL( clicked() ),
             this, SLOT( startServer() ) );

    layout->addWidget( group_box );
    return layout;
}

/*-------------------------------------------------------------------*/
/*!

*/
QLayout *
LauncherDialog::createLeftTeamControls()
{
    QHBoxLayout * layout = new QHBoxLayout();

    QHGroupBox * group_box = new QHGroupBox( tr( "Left Team" ), this );

    //QLabel * label = new QLabel( tr( "Command: " ), group_box );
    //label->setMinimumSize( 80,  this->fontMetrics().height() + 12 );
    //label->setMaximumSize( 100, this->fontMetrics().height() + 12 );

    M_left_team_commands = new QComboBox( group_box );
    M_left_team_commands->setEditable( true );
    M_left_team_commands->setAutoCompletion( true );
    M_left_team_commands->setMaxCount( MAX_HISTORY );
    M_left_team_commands->setDuplicatesEnabled( false );
    M_left_team_commands->setMinimumSize( 160, this->fontMetrics().height() + 12 );
    //M_left_team_commands->setMaximumSize( 240, this->fontMetrics().height() + 12 );

    QPushButton * execute_btn = new QPushButton( tr( "Start!" ), group_box );
    execute_btn->setMinimumSize( 80, this->fontMetrics().height() + 12 );
    execute_btn->setMaximumSize( 80, this->fontMetrics().height() + 12 );
    execute_btn->setAutoDefault( false );

    connect( execute_btn, SIGNAL( clicked() ),
             this, SLOT( startLeftTeam() ) );

    layout->addWidget( group_box );
    return layout;
}

/*-------------------------------------------------------------------*/
/*!

*/
QLayout *
LauncherDialog::createRightTeamControls()
{
    QHBoxLayout * layout = new QHBoxLayout();

    QHGroupBox * group_box = new QHGroupBox( tr( "Right Team" ), this );

    //QLabel * label = new QLabel( tr( "Command: " ), group_box );
    //label->setMinimumSize( 80,  this->fontMetrics().height() + 12 );
    //label->setMaximumSize( 100, this->fontMetrics().height() + 12 );

    M_right_team_commands = new QComboBox( group_box );
    M_right_team_commands->setEditable( true );
    M_right_team_commands->setAutoCompletion( true );
    M_right_team_commands->setMaxCount( MAX_HISTORY );
    M_right_team_commands->setDuplicatesEnabled( false );
    M_right_team_commands->setMinimumSize( 160, this->fontMetrics().height() + 12 );
    //M_right_team_commands->setMaximumSize( 240, this->fontMetrics().height() + 12 );

    QPushButton * execute_btn = new QPushButton( tr( "Start!" ), group_box );
    execute_btn->setMinimumSize( 80, this->fontMetrics().height() + 12 );
    execute_btn->setMaximumSize( 80, this->fontMetrics().height() + 12 );
    execute_btn->setAutoDefault( false );

    connect( execute_btn, SIGNAL( clicked() ),
             this, SLOT( startRightTeam() ) );

    layout->addWidget( group_box );
    return layout;
}

/*-------------------------------------------------------------------*/
/*!

*/
QLayout *
LauncherDialog::createExecuteControls()
{
    QHBoxLayout * layout = new QHBoxLayout();

    QPushButton * button = new QPushButton( tr( "Start All!" ), this );
    connect( button, SIGNAL( clicked() ),
             this, SLOT( startAll() ) );
    layout->addWidget( button, 10, Qt::AlignVCenter );
    button->setAutoDefault( false );

    QPushButton * cancel = new QPushButton( tr( "Close" ), this );
    cancel->setAutoDefault( false );
    connect( cancel, SIGNAL( clicked() ),
             this, SLOT( reject() ) );
    layout->addWidget( cancel, 2, Qt::AlignVCenter );

    return layout;
}

/*-------------------------------------------------------------------*/
/*!

*/
void
LauncherDialog::updateComboBox( QComboBox * combo_box )
{
    QString cur_text = combo_box->currentText();

    if ( cur_text.isEmpty() )
    {
        return;
    }

    int index = -1;

    const int count = combo_box->count();
    for ( int i = 0; i < count; ++i )
    {
        if ( combo_box->text( i ) == cur_text )
        {
            index = i;
            break;
        }
    }

    if ( index >= 0 )
    {
        for ( int i = index - 1; i >= 0; --i )
        {
            QString tmp = combo_box->text( i );
            combo_box->changeItem( tmp, i + 1 );
        }
        combo_box->changeItem( cur_text, 0 );
    }
    else
    {
        combo_box->insertItem( cur_text, 0 );
    }

    combo_box->setCurrentItem( 0 );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
LauncherDialog::startServer()
{
    QString command = M_rcssserver_command->text();

    std::cerr << "start server [" << command << "]" << std::endl;
    emit launchServer( command );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
LauncherDialog::startLeftTeam()
{
    updateComboBox( M_left_team_commands );

    std::string command = M_left_team_commands->currentText();

    std::cout << "start left team [" << command << "]" << std::endl;

    command += " &";
    std::system( command.c_str() );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
LauncherDialog::startRightTeam()
{
    updateComboBox( M_right_team_commands );

    std::string command = M_right_team_commands->currentText();

    std::cout << "start right team [" << command << "]" << std::endl;

    command += " &";
    std::system( command.c_str() );

    this->hide();
}

/*-------------------------------------------------------------------*/
/*!

*/
void
LauncherDialog::startAll()
{
    updateComboBox( M_left_team_commands );
    updateComboBox( M_right_team_commands );

    QString command = M_rcssserver_command->text().ascii();

    QString left_command = M_left_team_commands->currentText();
    QString right_command = M_right_team_commands->currentText();

    if ( ! left_command.isEmpty() )
    {
        command += " server::team_l_start = \'";
        command += left_command.ascii();
        command += "\'";
    }

    if ( ! right_command.isEmpty() )
    {
        command += " server::team_r_start = \'";
        command += right_command.ascii();
        command += "\'";
    }

    std::cerr << "start all [" << command.ascii() << "]" << std::endl;
    emit launchServer( command );

    this->hide();
}
