// -*-c++-*-

/*!
  \file app_config.h
  \brief Application configuration class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_APP_CONFIG_H
#define SOCCERWINDOW2_APP_CONFIG_H

#include <string>

/*!
  \class AppConfig
  \brief application configuration holder.
*/
class AppConfig {
public:

    static const int MIN_SCORE_BOARD_HEIGHT;
    static const int MAX_SCORE_BOARD_HEIGHT;

    static const int DEFAULT_TIMER_INTERVAL;

private:

    //
    // monitor client options
    //
    bool M_connect;
    std::string M_host;
    int M_port;
    int M_client_version;
    long M_wait_seconds;
    bool M_auto_quit_mode;
    bool M_kill_server;
    long M_server_pid;
    std::string M_server_path; //!< rcssserver command line path
    bool M_time_shift_replay;

    //
    // logplayer options
    //
    std::string M_game_log_file_path;
    std::string M_game_log_dir; //!< default dir to search game log
    bool M_auto_loop_mode;
    int M_timer_interval; //!< logplayer's timer interval. default 100[ms]

    //
    // debug server options
    //
    bool M_debug_server_mode;
    long M_debug_server_port;
    std::string M_debug_log_dir; //!< default dir to search debug log

    //
    // window options
    //
    int M_pos_x;
    int M_pos_y;
    int M_width;
    int M_height;
    bool M_maximize;
    bool M_full_screen;

    int M_canvas_width;
    int M_canvas_height;

    std::string M_tool_bar_area;
    bool M_hide_menu_bar;
    bool M_hide_tool_bar;
    bool M_hide_status_bar;

    //
    // view options
    //
    bool M_anonymous_mode;
    std::string M_draw_type;
    std::string M_field_grass_type;
    bool M_keepaway;

    bool M_show_score_board;
    bool M_show_team_logo;

    bool M_anti_aliasing;
    bool M_gradient;

    bool M_reverse_side;
    bool M_player_reverse_draw;

    bool M_show_player_number;
    bool M_show_player_type;
    bool M_show_view_cone;
    bool M_show_stamina;

    double M_enlarged_ball_size;
    double M_fixed_player_size;

    //
    // image save options
    //
    bool M_auto_image_save;
    std::string M_image_save_dir;
    std::string M_image_name_prefix;
    std::string M_image_save_format;

    // not a command line option

    // now soccerwindow2 is a monitor client mode
    bool M_monitor_client_mode;

    //! private access for singleton
    AppConfig();

    //! noncopyable
    AppConfig( const AppConfig & );
    //! noncopyable
    AppConfig & operator=( const AppConfig & );

public:
    ~AppConfig();

    static
    AppConfig & instance();

    /*!
      \biref analyze command line options
    */
    bool parseCmdLine( int argc,
                       char ** argv );

    const
    std::string & gameLogFilePath() const
      {
          return M_game_log_file_path;
      }

    const
    std::string & gameLogDir() const
      {
          return M_game_log_dir;
      }

    void setGameLogDir( const std::string & dir )
      {
          M_game_log_dir = dir;
      }

    bool timeShiftReplay() const
      {
          return M_time_shift_replay;
      }

    bool autoLoopMode() const
      {
          return M_auto_loop_mode;
      }

    const
    std::string & imageSaveDir() const
      {
          return M_image_save_dir;
      }

    const
    std::string & imageNamePrefix() const
      {
          return M_image_name_prefix;
      }

    const
    std::string & imageSaveFormat() const
      {
          return M_image_save_format;
      }

    int timerInterval() const
      {
          return M_timer_interval;
      }

    bool connect() const
      {
          return M_connect;
      }

    const
    std::string & host() const
      {
          return M_host;
      }

    int port() const
      {
          return M_port;
      }

    int clientVersion() const
      {
          return M_client_version;
      }

    const
    long & waitSeconds() const
      {
          return M_wait_seconds;
      }

    bool autoQuitMode() const
      {
          return M_auto_quit_mode;
      }

    bool killServer() const
      {
          return M_kill_server;
      }

    void setKillServer( bool on )
      {
          M_kill_server = on;
      }

    const
    long & serverPID() const
      {
          return M_server_pid;
      }

    void setServerPID( const long & pid )
      {
          M_server_pid = pid;
      }

    const
    std::string & serverPath() const
      {
          return M_server_path;
      }

    bool anonymousMode() const
      {
          return M_anonymous_mode;
      }

    bool maximize() const
      {
          return M_maximize;
      }

    bool fullScreen() const
      {
          return M_full_screen;
      }

    int framePosX() const
      {
          return M_pos_x;
      }

    int framePosY() const
      {
          return M_pos_y;
      }

    int frameWidth() const
      {
          return M_width;
      }

    int frameHeight() const
      {
          return M_height;
      }

    int canvasWidth() const
      {
          return M_canvas_width;
      }

    int canvasHeight() const
      {
          return M_canvas_height;
      }

    const
    std::string & toolBarArea() const
      {
          return M_tool_bar_area;
      }

    bool hideMenuBar() const
      {
          return M_hide_menu_bar;
      }

    bool hideToolBar() const
      {
          return M_hide_tool_bar;
      }

    bool hideStatusBar() const
      {
          return M_hide_status_bar;
      }

    bool antiAliasing() const
      {
          return M_anti_aliasing;
      }

    bool gradient() const
      {
          return M_gradient;
      }

    bool reverseSide() const
      {
          return M_reverse_side;
      }

    bool playerReverseDraw() const
      {
          return M_player_reverse_draw;
      }

    bool showPlayerNumber() const
      {
          return M_show_player_number;
      }

    bool showPlayerType() const
      {
          return M_show_player_type;
      }

    bool showViewCone() const
      {
          return M_show_view_cone;
      }

    bool showStamina() const
      {
          return M_show_stamina;
      }

    const
    std::string & fieldGrassType() const
      {
          return M_field_grass_type;
      }

    const
    double & enlargedBallSize() const
      {
          return M_enlarged_ball_size;
      }

    const
    double & fixedPlayerSize() const
      {
          return M_fixed_player_size;
      }

    bool keepaway() const
      {
          return M_keepaway;
      }

    bool showScoreBoard() const
      {
          return M_show_score_board;
      }

    bool showTeamLogo() const
      {
          return M_show_team_logo;
      }

    bool debugServerMode() const
      {
          return M_debug_server_mode;
      }
    const
    long & debugServerPort() const
      {
          return M_debug_server_port;
      }

    const
    std::string & debugLogDir() const
      {
          return M_debug_log_dir;
      }

    void setDebugLogDir( const std::string & dir )
      {
          M_debug_log_dir = dir;
      }

    const
    std::string & drawType() const
      {
          return M_draw_type;
      }

    bool autoImageSave() const
      {
          return M_auto_image_save;
      }

    bool monitorClientMode() const
      {
          return M_monitor_client_mode;
      }

    void setMonitorClientMode( bool on )
      {
          M_monitor_client_mode = on;
      }
};

#endif
