// -*-c++-*-

/*!
  \file main_window.h
  \brief main application window class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef FEDIT_QT3_MAIN_WINDOW_H
#define FEDIT_QT3_MAIN_WINDOW_H

#include <qmainwindow.h>

#include <boost/shared_ptr.hpp>

class QAction;
class QCloseEvent;
class QLabel;
class QResizeEvent;
class QSpinBox;
class QString;
class QToolBar;
class QWheelEvent;

class FEditCanvas;
class FEditData;
class FEditDialog;

class MainWindow
    : public QMainWindow {

    Q_OBJECT

private:

    //! data instance
    boost::shared_ptr< FEditData > M_editor_data;

    FEditCanvas * M_editor_canvas;
    FEditDialog * M_editor_dialog;

    QToolBar * M_tool_bar;
    QLabel * M_position_label;
    QSpinBox * M_index_spin_box;

    // file actions
    QAction * M_new_file_act;
    QAction * M_open_act;
    QAction * M_open_train_act;
    QAction * M_save_all_act;
    QAction * M_save_act;
    QAction * M_save_as_act;
    QAction * M_save_train_act;
    QAction * M_save_train_as_act;
    QAction * M_exit_act;

    // mode actions
    QAction * M_toggle_ball_drag_act;
    QAction * M_toggle_player_auto_move_act;
    QAction * M_toggle_data_auto_select_act;
    QAction * M_toggle_symmetric_mode_act;

    QAction * M_show_edit_dialog_act;

    // edit actions
    QAction * M_insert_data_act;
    QAction * M_replace_data_act;
    QAction * M_delete_data_act;
    QAction * M_reverse_y_act;
    QAction * M_train_act;
    QAction * M_record_data_act;

    // view actions
    QAction * M_zoom_in_act;
    QAction * M_zoom_out_act;
    QAction * M_fit_act;
    QAction * M_toggle_enlarge_act;
    QAction * M_toggle_show_index_act;
    QAction * M_toggle_show_circumcircle_act;

    // help actions
    QAction * M_about_act;

    // not used
    MainWindow( const MainWindow & );
    const MainWindow & operator=( const MainWindow & );

public:

    MainWindow();
    ~MainWindow();

    void init();

private:

    void loadSettings();
    void saveSettings();

    void createActions();
    void createActionsFile();
    void createActionsMode();
    void createActionsData();
    void createActionsView();
    void createActionsHelp();


    void createMenus();
    void createMenuFile();
    void createMenuEdit();
    void createMenuMode();
    void createMenuView();
    void createMenuHelp();

    void createToolBars();
    void createStatusBar();

    void createFieldCanvas();
    void createEditDialog();

    bool saveChanged();

    bool openConfFile( const QString & filepath );

protected:

    // overrided method (virtual in super)
    void closeEvent( QCloseEvent * event );
    void resizeEvent( QResizeEvent * event );
    void wheelEvent( QWheelEvent * event );

public slots:

    // help menu actions slots
    void about();

    void resizeCanvas( const QSize & size );

    void toggleToolBar();
    void toggleStatusBar();
    void toggleFullScreen();

    void changeStyle( const QString & style );
    void updatePositionLabel( const QString & str );

    // file menu actions slots
    void newFile();
    void open();
    void open( const QString & filepath );
    void openData();
    bool openDataFile( const QString & filepath );
    void saveAll();
    void save();
    void saveAs();
    void saveTrainingData();
    void saveTrainingDataAs();

    void toggleBallDrag( bool on );
    void togglePlayerAutoMove( bool on );
    void toggleDataAutoSelect( bool on );
    void toggleSymmetricMode( bool on );

    void showEditDialog( bool on );

    void recordData();
    void insertData();
    void replaceData();
    void deleteData();
    void reverseY();
    void train();

    void setTrainingDataSize();
    void changeDataIndex( int idx );
    void updateDataIndex();

signals:
    void viewUpdated();

};

#endif
