// -*-c++-*-

/*!
	\file command.h
	\brief command object for redo/undo Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa Akiyama

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.	If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef FEDIT_QT3_COMMAND_H
#define FEDIT_QT3_COMMAND_H

#include <rcsc/formation/formation.h>

class FEditData;

class Command {
private:

    // not used
    Command( const Command & );
    const Command & operator=( const Command & );
protected:

    Command()
      { }

public:

    virtual
    ~Command()
      { }

    /*!
      \brief get the information text about the operation
      \return information text string
     */
    virtual
    std::string text() const = 0;

    virtual
    bool redo( FEditData & fedit_data ) = 0;

    virtual
    bool undo( FEditData & fedit_data ) = 0;

};


/*-------------------------------------------------------------------*/

class RecordCommand
    : public Command {
private:
    const rcsc::Formation::Snapshot M_recorded_data;
    const bool M_symmetry;
    int M_added_size;
public:

    RecordCommand( const rcsc::Formation::Snapshot & recorded_data,
                   const bool symmetry );

    std::string text() const;

    bool redo( FEditData & fedit_data );

    bool undo( FEditData & fedit_data );
};

/*-------------------------------------------------------------------*/

class DeleteCommand
    : public Command {
private:

    const int M_deleted_index;
    const rcsc::Formation::Snapshot M_deleted_data;

public:

    explicit
    DeleteCommand( const int deleted_index );

    std::string text() const;

    bool redo( FEditData & fedit_data );

    bool undo( FEditData & fedit_data );

};

/*-------------------------------------------------------------------*/

class ReplaceCommand
    : public Command {
private:

    const int M_replaced_index;
    const rcsc::Formation::Snapshot M_replaced_data;
    const bool M_symmetry;

public:

    ReplaceCommand( const int replaced_index,
                    const rcsc::Formation::Snapshot & replaced_data,
                    const bool symmetry );

    std::string text() const;

    bool redo( FEditData & fedit_data );

    bool undo( FEditData & fedit_data );

};

/*-------------------------------------------------------------------*/

class MoveCommand
    : public Command {
private:

    const rcsc::Formation::Snapshot M_prev_data;

public:

    MoveCommand( const rcsc::Formation::Snapshot & prev_data );

    std::string text() const;

    bool redo( FEditData & fedit_data );

    bool undo( FEditData & fedit_data );

};

/*-------------------------------------------------------------------*/

class RoleAssignCommand
    : public Command {
private:

    const int M_unum;
    // previous data
    const rcsc::Formation::SideType M_side_type;
    const int M_symmetry_unum;
    const std::string & M_role_name;

public:

    RoleAssignCommand( const int unum,
                       const rcsc::Formation::SideType side_type,
                       const int symmetry_unum,
                       const std::string & role_name );

    std::string text() const;

    bool redo( FEditData & fedit_data );

    bool undo( FEditData & fedit_data );

};



#endif
