// -*-c++-*-

/*!
	\file command.cpp
	\brief command object for execute/undo Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa Akiyama

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.	If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "command.h"

#include "fedit_data.h"

/*-------------------------------------------------------------------*/
/*!

*/
RecordCommand::RecordCommand( const rcsc::Formation::Snapshot & recorded_data,
                              const bool symmetry )
    : M_recorded_data( recorded_data )
    , M_symmetry( symmetry )
    , M_added_size( 0 )
{

}

/*-------------------------------------------------------------------*/
/*!

*/
std::string
RecordCommand::text() const
{
    return std::string( "Record" );
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
RecordCommand::redo( FEditData & fedit_data )
{
    int old_size = fedit_data.trainingData().size();
    fedit_data.recordTrainingData( M_recorded_data, M_symmetry );
    int new_size = fedit_data.trainingData().size();
    M_added_size = new_size - old_size;

    return M_added_size > 0;
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
RecordCommand::undo( FEditData & fedit_data )
{
    while ( M_added_size > 0 )
    {
        int idx = fedit_data.trainingData().size();

        fedit_data.deleteTrainingData( idx );
    }

    return true;
}

/*-------------------------------------------------------------------*/

/*-------------------------------------------------------------------*/
/*!

*/
DeleteCommand::DeleteCommand( const int deleted_index )
    : M_deleted_index( deleted_index )
{

}

/*-------------------------------------------------------------------*/
/*!

*/
std::string
DeleteCommand::text() const
{
    return std::string( "Delete" );
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
DeleteCommand::redo( FEditData & fedit_data )
{
    return true;
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
DeleteCommand::undo( FEditData & fedit_data )
{
    return true;
}


/*-------------------------------------------------------------------*/

/*-------------------------------------------------------------------*/
/*!

*/
ReplaceCommand::ReplaceCommand( const int replaced_index,
                                const rcsc::Formation::Snapshot & replaced_data,
                                const bool symmetry )
    : M_replaced_index( replaced_index )
    , M_replaced_data( replaced_data )
    , M_symmetry( symmetry )
{

}

/*-------------------------------------------------------------------*/
/*!

*/
std::string
ReplaceCommand::text() const
{
    return std::string( "Replace" );
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
ReplaceCommand::redo( FEditData & fedit_data )
{
    return true;
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
ReplaceCommand::undo( FEditData & fedit_data )
{
    return true;
}


/*-------------------------------------------------------------------*/

/*-------------------------------------------------------------------*/
/*!

*/
MoveCommand::MoveCommand( const rcsc::Formation::Snapshot & prev_data )
    : M_prev_data( prev_data )
{

}

/*-------------------------------------------------------------------*/
/*!

*/
std::string
MoveCommand::text() const
{
    return std::string( "Move" );
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
MoveCommand::redo( FEditData & fedit_data )
{
    return true;
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
MoveCommand::undo( FEditData & fedit_data )
{
    return true;
}


/*-------------------------------------------------------------------*/

/*-------------------------------------------------------------------*/
/*!

*/
RoleAssignCommand::RoleAssignCommand( const int unum,
                                      const rcsc::Formation::SideType side_type,
                                      const int symmetry_unum,
                                      const std::string & role_name )
    : M_unum( unum )
    , M_side_type( side_type )
    , M_symmetry_unum( symmetry_unum )
    , M_role_name( role_name )
{

}

/*-------------------------------------------------------------------*/
/*!

*/
std::string
RoleAssignCommand::text() const
{
    return std::string( "RoleAssign" );
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
RoleAssignCommand::redo( FEditData & fedit_data )
{
    return true;
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
RoleAssignCommand::undo( FEditData & fedit_data )
{
    return true;
}
