// -*-c++-*-

/*!
  \file offside_line_painter.cpp
  \brief offside line painter class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

// for compliers supporting precompling
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

// for compliers NOT supporting precompling
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include "app_config.h"
#include "main_data.h"
#include "monitor_view_data.h"

#include "offside_line_painter.h"

/*-------------------------------------------------------------------*/
/*!
  \param dc reference to the device context
*/
void
OffsideLinePainter::draw( wxDC & dc ) const
{
    const ViewConfig & conf = M_data.config();
    const MonitorViewPtr view = M_data.getCurrentViewData();

    if ( ! view )
    {
        return;
    }

    const double ball_x = view->ball().x();
    const std::vector< Player > & players = view->players();

    double offside_l = 0.0;
    {
        double min_x = 0.0;
        for ( std::size_t i = 0; i < 11; ++i )
        {
            if ( players[i].isAlive() )
            {
                double x = players[i].x();
                if ( x < offside_l )
                {
                    if ( x < min_x )
                    {
                        offside_l = min_x;
                        min_x = x;
                    }
                    else
                    {
                        offside_l = x;
                    }
                }
            }
        }
        offside_l = std::min( offside_l, ball_x );
        offside_l = std::max( offside_l, - AppConfig::PITCH_LENGTH * 0.5 );
    }
    const int offside_line_l = conf.getScreenX( offside_l );

    double offside_r = 0.0;
    {
        double max_x = 0.0;
        for ( std::size_t i = 11; i < 22; ++i )
        {
            if ( players[i].isAlive() )
            {
                double x = players[i].x();
                if ( offside_r < x )
                {
                    if ( max_x < x )
                    {
                        offside_r = max_x;
                        max_x = x;
                    }
                    else
                    {
                        offside_r = x;
                    }
                }
            }
        }
        offside_r = std::max( offside_r, ball_x );
        offside_r = std::min( offside_r, AppConfig::PITCH_LENGTH * 0.5 );
    }
    const int offside_line_r = conf.getScreenX( offside_r );

    const int top_y = conf.getScreenY( AppConfig::PITCH_WIDTH * 0.5 );
    const int bottom_y = conf.getScreenY( - AppConfig::PITCH_WIDTH * 0.5 );

    dc.SetBrush( *wxTRANSPARENT_BRUSH );

    dc.SetPen( M_data.gdi().getLeftTeamPen() );
    dc.DrawLine( offside_line_l, top_y,
                 offside_line_l, bottom_y );

    dc.SetPen( M_data.gdi().getRightTeamPen() );
    dc.DrawLine( offside_line_r, top_y,
                 offside_line_r, bottom_y );
}
