// -*-c++-*-

/*!
  \file main_toolbar.cpp
  \brief Main Toolbar class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include <cassert>
#include <iostream>

//#include "xpm/open_rcg.xpm"
#include "xpm/logplayer_shift_down.xpm"
#include "xpm/logplayer_shift_up.xpm"
#include "xpm/logplayer_go_first.xpm"
#include "xpm/logplayer_go_last.xpm"
#include "xpm/logplayer_go_next_score.xpm"
#include "xpm/logplayer_go_prev_score.xpm"
#include "xpm/logplayer_one_step_back.xpm"
#include "xpm/logplayer_one_step_forward.xpm"
//#include "xpm/logplayer_play_back.xpm"
//#include "xpm/logplayer_play_forward.xpm"
//#include "xpm/logplayer_stop.xpm"
#include "xpm/logplayer_play_or_stop.xpm"
#include "xpm/logplayer_live_mode.xpm"

#include "id.h"
#include "main_data.h"
#include "main_frame.h"
#include "view_holder.h"

#include "main_toolbar.h"

/*-------------------------------------------------------------------*/
/*!
  create new toolbar window
  \param parent pointer to the parent window
  \return pointer to the new toolbar object on the heap
*/
MainToolBar::MainToolBar( wxWindow * parent,
                          const long & style,
                          MainFrame * main_frame,
                          const MainData & data )
    : wxToolBar( parent, SWID_TOOLBAR_LOGPLAYER,
                 wxDefaultPosition, wxDefaultSize,
                 style )
    , M_main_frame( main_frame )
    , M_data( data )
    , M_cycle_slider( static_cast< wxSlider * >( 0 ) )
    , M_cycle_text_box( static_cast< wxTextCtrl * >( 0 ) )
{
    assert( parent );
    assert( main_frame );

    createTools();

    // connect event handler
    connectEvents();

    this->Realize();
}

/*-------------------------------------------------------------------*/
/*!

*/
MainToolBar::~MainToolBar()
{
    //std::cerr << "delete MainToolBar" << std::endl;
}

/*-------------------------------------------------------------------*/
/*!
  \brief add tool buttons.
*/
void
MainToolBar::createTools()
{
    //this->AddTool( SWID_SHOW_OPEN_RCG_DIALOG, _( "Open RCG" ),
    //               wxBitmap( open_rcg_xpm ),
    //               _( "Open RCG file" ) );
    //this->AddSeparator();

    this->AddTool( SWID_LOGPLAYER_GOTO_FIRST, _( "Go top" ),
                   wxBitmap( logplayer_go_first_xpm ),
                   _( "Go to first(Home)" ) );
    this->AddTool( SWID_LOGPLAYER_GOTO_PREV_SCORE, _( "Go score" ),
                   wxBitmap( logplayer_go_prev_score_xpm ),
                   _( "Go to previous score scene" ) );
    //this->AddTool( SWID_LOGPLAYER_PLAY_BACK, _( "Play back" ),
    //               wxBitmap( logplayer_play_back_xpm ),
    //               _( "Play backward" ) );
    this->AddTool( SWID_LOGPLAYER_STEP_BACK, _( "Step back" ),
                   wxBitmap( logplayer_one_step_back_xpm ),
                   _( "One step back(Left)" ) );
    this->AddTool( SWID_LOGPLAYER_PLAY_OR_STOP, _( "Play/Stop" ),
                   wxBitmap( logplayer_play_or_stop_xpm ),
                   _( "Play/Stop(Space)" ) );
    //this->AddTool( SWID_LOGPLAYER_STOP, _( "Stop" ),
    //wxBitmap( logplayer_stop_xpm ),
    //_( "Stop" ) );
    //this->AddTool( SWID_LOGPLAYER_PLAY_FORWARD, _( "Play" ),
    //wxBitmap( logplayer_play_forward_xpm ),
    //_( "Play" ) );
    this->AddTool( SWID_LOGPLAYER_STEP_FORWARD, _( "Step forward" ),
                   wxBitmap( logplayer_one_step_forward_xpm ),
                   _( "One step forward(Right)" ) );
    this->AddTool( SWID_LOGPLAYER_GOTO_NEXT_SCORE, _( "Go score" ),
                   wxBitmap( logplayer_go_next_score_xpm ),
                   _( "Go to next score scene(G)" ) );
    this->AddTool( SWID_LOGPLAYER_GOTO_LAST, _( "Go end" ),
                   wxBitmap( logplayer_go_last_xpm ),
                   _( "Go to last(End)" ) );
    this->AddTool( SWID_LOGPLAYER_DECELERATE, _( "Shift down" ),
                   wxBitmap( logplayer_shift_down_xpm ),
                   _( "Decelerate(Ctrl+Left)" ) );
    this->AddTool( SWID_LOGPLAYER_ACCELERATE, _( "Shift up" ),
                   wxBitmap( logplayer_shift_up_xpm ),
                   _( "Accelerate(Ctrl+Right)" ) );

    //--------------------------------------------------------------
    this->AddSeparator();
    M_cycle_slider = createCycleSlider( this );
    this->AddControl( M_cycle_slider );
    M_cycle_slider->SetPageSize( 1 ); // set the minimal increment/decrement step

    //this->AddSeparator();
    M_cycle_text_box = createCycleTextBox( this );
    this->AddControl( M_cycle_text_box );

    this->AddTool( SWID_REQUEST_LIVE_MODE, _( "Live Mode" ),
                   wxBitmap( logplayer_live_mode_xpm ),
                   _( "Live Mode" ) );
}

/*-------------------------------------------------------------------*/
/*!
  create new cycle slider window
  \param parent pointer to the parent window
  \return pointer to the new slider object on the heap
*/
wxSlider *
MainToolBar::createCycleSlider( wxWindow * parent )
{
    wxSlider * slider =
        new wxSlider( parent,
                      SWID_SLIDER_LOGPLAYER,
                      1, 0, 0,  // value, min value, max value
                      wxDefaultPosition, wxSize( 300, -1 ),
                      wxSL_HORIZONTAL
                      | wxSL_AUTOTICKS );
    slider->SetLineSize( 10 );
    slider->SetPageSize( 1 ); // set the minimal increment/decrement step

    return slider;
}

/*-------------------------------------------------------------------*/
/*!
  \brief create & return new cycle text box window
  \param parent pointer to the parent window
  \return pointer to the new text box object on the heap
*/
wxTextCtrl *
MainToolBar::createCycleTextBox( wxWindow * parent )
{
    wxTextCtrl * text =
        new wxTextCtrl( parent,
                        SWID_TEXTBOX_LOGPLAYER,
                        wxT( "0" ),
                        wxDefaultPosition, wxSize( 40, -1 ),
                        wxTE_PROCESS_ENTER );
    return text;
}

/*-------------------------------------------------------------------*/
/*!
  \brief connect wx event handers
*/
void
MainToolBar::connectEvents()
{
    /*
      wxEVT_SCROLL_TOP
      wxEVT_SCROLL_BOTTOM
      wxEVT_SCROLL_LINEUP
      wxEVT_SCROLL_LINEDOWN
      wxEVT_SCROLL_PAGEUP
      wxEVT_SCROLL_PAGEDOWN
      wxEVT_SCROLL_THUMBTRACK
      wxEVT_SCROLL_THUMBRELEASE
      wxEVT_SCROLL_ENDSCROLL
    */
    Connect( SWID_SLIDER_LOGPLAYER, wxEVT_SCROLL_THUMBTRACK,
             wxScrollEventHandler( MainToolBar::handleSliderScroll ) );
    Connect( SWID_TEXTBOX_LOGPLAYER, wxEVT_COMMAND_TEXT_ENTER,
             wxTextEventHandler( MainToolBar::handleCycleTextEnter ) );
}

/*-------------------------------------------------------------------*/
/*!
  \brief handle slider scroll event
  \param event event object. but not used.
*/
void
MainToolBar::handleSliderScroll( wxScrollEvent & WXUNUSED(event) )
{
    std::size_t idx = static_cast< std::size_t >( M_cycle_slider->GetValue() );
    M_main_frame->handle( EventMessage( SWID_LOGPLAYER_GOTO_INDEX, idx ) );
}

/*-------------------------------------------------------------------*/
/*!
  handle enter event on cycle text box
  \param event event object. but not used.
*/
void
MainToolBar::handleCycleTextEnter( wxCommandEvent & WXUNUSED(event) )
{
    wxString val = M_cycle_text_box->GetValue();
    unsigned long ucycle = 0;
    if ( ! val.ToULong( &ucycle ) )
    {
        return;
    }

    long cycle = static_cast< long >( ucycle );
    if ( 0 <= cycle
         && cycle <= M_cycle_slider->GetMax() )
    {
        M_main_frame->handle( EventMessage( SWID_LOGPLAYER_GOTO_CYCLE,
                                            cycle ) );
    }
}

/*-------------------------------------------------------------------*/
/*!

*/
void
MainToolBar::update()
{
    if ( ! this->IsShown() )
    {
        return;
    }

    int size = M_data.getViewHolder().getMonitorViewCont().size();
    if ( size == 1 ) size = 0;
    if ( M_cycle_slider->GetMax() != size )
    {
        M_cycle_slider->SetRange( 0, size );
    }

    int val = static_cast< int >( M_data.getViewIndex() );
    if ( M_cycle_slider->GetValue() != val )
    {
        M_cycle_slider->SetValue( val );
    }
}

