// -*-c++-*-

/*!
  \file main_data.h
  \brief main data supplier class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCER_WINDOW2_MAIN_DATA_H
#define SOCCER_WINDOW2_MAIN_DATA_H

#include <boost/shared_ptr.hpp>
#include <boost/utility.hpp>

#include "gdi_config.h"
#include "view_config.h"
#include "view_holder.h"

class MainFrame;

//! abstraction data class
class MainData
    : public boost::noncopyable {
private:

    //! pointer to the main frame instance
    MainFrame * M_main_frame;

    //! drawing configration
    GDIConfig M_gdi_config;

    //! field canvas configuration
    ViewConfig M_view_config;

    //! view data holder
    ViewHolder M_view_holder;

    //! current view data index in M_view_holder
    std::size_t M_view_index;


    // not used
    MainData();

public:
    explicit
    MainData( MainFrame * frame );

    void clear();

    bool loadRCG( const std::string & file_path );


    /*!
      \brief get GDI configuration
      \return const reference to the GDIConfig instance.
    */
    const
    GDIConfig & gdi() const
      {
          return M_gdi_config;
      }

    ViewConfig & getViewConfig()
      {
          return M_view_config;
      }

    const
    ViewConfig & config() const
      {
          return M_view_config;
      }

    ViewHolder & getViewHolder()
      {
          return M_view_holder;
      }

    const
    ViewHolder & getViewHolder() const
      {
          return M_view_holder;
      }

    std::size_t getViewIndex() const
      {
          return M_view_index;
      }

    const
    MonitorViewPtr getCurrentViewData() const
      {
          return getViewHolder().getViewData( getViewIndex() );
      }

    void setViewIndex( const std::size_t idx )
      {
          if ( idx < getViewHolder().getMonitorViewCont().size() )
          {
              M_view_index = idx;
          }
      }

    //! update draw area size
    void update( const int width,
                 const int height );

private:

    void selectBallNearestPlayer( const boost::shared_ptr< MonitorViewData > view );

    void startDebugServer();

    /////////////////////////////////////////////////////////
    // event message handlers

    void recvSetViewDataIndex( const boost::any * data );
    void recvSetViewDataIndexFirst( const boost::any * );
    void recvSetViewDataIndexLast( const boost::any * );
    void recvSetViewDataCycle( const boost::any * data );
    void recvStepViewDataForward( const boost::any * );
    void recvStepViewDataBack( const boost::any * );

};

#endif
