// -*-c++-*-

/*!
  \file logplayer.h
  \brief log player Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCER_WINDOW2_LOG_PLAYER_H
#define SOCCER_WINDOW2_LOG_PLAYER_H

#include <boost/any.hpp>

class MainData;
class MainFrame;

//! logplayer class.
class LogPlayer
    : public wxEvtHandler {
private:

    MainFrame * M_main_frame;

    //! main data supplier
    const MainData & M_data;

    //! timer event invoker
    wxTimer M_timer;

    //! if true, play direction is forward
    bool M_forward;

    //! if true, latest monitor view data is requested.
    bool M_live_mode;

    //! not used
    LogPlayer();
    //! nocopyable
    LogPlayer( const LogPlayer & );
    //! nocopyable
    LogPlayer& operator=( const LogPlayer & );

public:

    //! constructor.
    LogPlayer( MainFrame * main_frame,
               const MainData & data );

    bool isLiveMode() const
      {
          return M_live_mode;
      }

    void setLiveMode();

private:
    //--------------------------------------
    //! timer event handler
    void handleTimer( wxTimerEvent & event );

    //--------------------------------------
    //! step to next cycle and draw it
    void stepForward();
    //! step to previous cycle and draw it.
    void stepBack();
    //! stop to play. this means timer is stopped.
    void stop();
    //! start to play forward mode
    void playForward();
    //! start to play backword mode.
    void playBack();

    //--------------------------------------

    //! event message handler
    void recvLogPlayerPlayForward( const boost::any * )
      {
          M_live_mode = false;
          playForward();
      }
    //! event message handler
    void recvLogPlayerPlayBack( const boost::any * )
      {
          M_live_mode = false;
          playBack();
      }
    //! event message handler
    void recvLogPlayerStop( const boost::any * )
      {
          M_live_mode = false;
          stop();
      }
    //! event message handler
    void recvLogPlayerPlayOrStop( const boost::any * );
    //! event message handler
    void recvLogPlayerStepForward( const boost::any * )
      {
          M_live_mode = false;
          stop();
          stepForward();
      }
    //! event message handler
    void recvLogPlayerStepBack( const boost::any * )
      {
          M_live_mode = false;
          stop();
          stepBack();
      }
    //! event message handler
    void recvLogPlayerAccelerate( const boost::any * );
    //! event message handler
    void recvLogPlayerDecelerate( const boost::any * );
    //! event message handler
    void recvLogPlayerGoToFirst( const boost::any * );
    //! event message handler
    void recvLogPlayerGoToLast( const boost::any * );
    //! event message handler
    void recvLogPlayerGoToPrevScore( const boost::any * );
    //! event message handler
    void recvLogPlayerGoToNextScore( const boost::any * );

    //! event message handler
    void recvLogPlayerGoToIndex( const boost::any * data );
    //! event message handler
    void recvLogPlayerGoToCycle( const boost::any * data );
};

#endif
