// -*-c++-*-

/*!
	\file field_canvas.h
	\brief field canvas class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.	If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCER_WINDOW2_FIELD_CANVAS_H
#define SOCCER_WINDOW2_FIELD_CANVAS_H

#include <string>
#include <boost/scoped_ptr.hpp>
#include <boost/any.hpp>

#include "mouse_state.h"

class MainData;
class MainFrame;

///////////////////////////////////////////////////////////////////////
//! main soccer field canvas class
class FieldCanvas
		: public wxWindow {
private:
    //! main control
    MainFrame * M_main_frame;

    //! main data supplier
    MainData & M_data;

    //! popup menu
    boost::scoped_ptr< wxMenu > M_normal_menu;
    //! popup menu
    boost::scoped_ptr< wxMenu > M_system_menu;
    //! popup menu
    boost::scoped_ptr< wxMenu > M_monitor_menu;

		//! bitmap buffer of draw area.
		wxBitmap M_canvas_bmp;


    //! 0: left, 1: middle, 2: right
    MouseState M_mouse_state[3];

public:
		//! constructor
		FieldCanvas( wxWindow * parent,
                 MainFrame * main_frame,
                 MainData & data );

		//! destructor
		~FieldCanvas();

private:

    void createWindows();
    void connectEvents();

		//----------------------------------------------
		//! event handler for EVT_PAINT
		void handlePaint( wxPaintEvent & event );

    void handleMenuEvent( wxCommandEvent & event );

		//--------------------------------------------------
		//! Mouse Event handler.
		void handleLeftDown( wxMouseEvent & event );
		//! Mouse Event handler.
		void handleLeftUp( wxMouseEvent & event );
		//! Mouse Event handler.
		void handleMiddleDown( wxMouseEvent & event );
		//! Mouse Event handler.
		void handleMiddleUp( wxMouseEvent & event );
		//! Mouse Event handler.
		void handleRightDown( wxMouseEvent & event );
		//! Mouse Event handler.
		void handleRightUp( wxMouseEvent & event );
		//! Mouse Event handler.
		void handleMouseMotion( wxMouseEvent & event );

		//! Keyboard Event handler.
		void handleChar( wxKeyEvent & event );
		//! Keyboard Event handler.
		void handleKeyDown( wxKeyEvent & event );

		//! key code handling method
		bool doHandleKeyCode( wxKeyEvent & event );

		//--------------------------------------------------

    void recvDrawViewData( const boost::any * )
      {
          draw();
      }

    void recvDisplayDebugMessage( const boost::any * )
      {
          draw();
      }

    void recvMenuMonitorDropBall( const boost::any * );
    void recvMenuMonitorFreeKickLeft( const boost::any * );
    void recvMenuMonitorFreeKickRight( const boost::any * );

public:
		//--------------------------------------------------
		//! redraw client DC
		void draw();

    void drawAll( wxDC & mem_dc );
private:
		//----------------------------------------------
		//! redraw all screen
		void draw( wxDC & dc );

		//! draw line of mouse measure
		void drawMouseMeasure( wxDC & mem_dc );

};

#endif
