// -*-c++-*-

/*!
  \file debug_message_frame.cpp
  \brief debug management frame class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

// for compliers supporting precompling
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

// for compliers NOT supporting precompling
#ifndef WX_PRECOMP
#include <wx/wx.h>
#include <wx/config.h>   // wxFileConfig
#include <wx/fileconf.h> // wxFileConfig
#include <wx/tglbtn.h>
#include <wx/notebook.h>
#endif

#include <cassert>
#include <cstdlib> // getenv
#include <iostream>

#include "xpm/open_dir.xpm"
#if 1
#include "xpm/num_1.xpm"
#include "xpm/num_2.xpm"
#include "xpm/num_3.xpm"
#include "xpm/num_4.xpm"
#include "xpm/num_5.xpm"
#include "xpm/num_6.xpm"
#include "xpm/num_7.xpm"
#include "xpm/num_8.xpm"
#include "xpm/num_9.xpm"
#include "xpm/num_10.xpm"
#include "xpm/num_11.xpm"
#include "xpm/num_12.xpm"
#include "xpm/num_13.xpm"
#include "xpm/num_14.xpm"
#include "xpm/num_15.xpm"
#include "xpm/num_16.xpm"
#endif

#include "xpm/debug_view_all.xpm"
#include "xpm/debug_view_self.xpm"
#include "xpm/debug_view_ball.xpm"
#include "xpm/debug_view_player.xpm"
#include "xpm/debug_view_comment.xpm"
#include "xpm/debug_view_line.xpm"
#include "xpm/debug_view_target.xpm"
#include "xpm/debug_view_message.xpm"

//#include "xpm/left.xpm"
//#include "xpm/right.xpm"

#include "xpm/sync.xpm"
#include "xpm/logplayer_one_step_back.xpm"
#include "xpm/logplayer_one_step_forward.xpm"

#include "id.h"
#include "soccerwindow_app.h"
#include "app_config.h"

#include "main_data.h"
#include "main_frame.h"
#include "debug_log_holder.h"
#include "debug_log_data.h"
#include "debug_log_dir_dialog.h"

#include "debug_message_frame.h"

/*-------------------------------------------------------------------*/
/*!

*/
DebugMessageFrame::DebugMessageFrame( wxWindow * parent,
                                      MainFrame * main_frame,
                                      MainData & data )
    : wxFrame( parent, SWID_FRAME_DEBUG_MESSAGE,
               wxT( "Debug Message" ),
               wxDefaultPosition, //wxPoint( 32, 32 ),
               wxSize( 640, 480 ),
               wxDEFAULT_FRAME_STYLE // | wxFRAME_FLOAT_ON_PARENT
               )
    , M_main_frame( main_frame )
    , M_data( data )
    , M_debug_holder( new DebugLogHolder )
    , M_selection( 0 )
    , M_level( 0xFFFF )
{
    assert( main_frame );

    // create internal windows
    createWindows();
    // set event handlers
    connectEvents();

    loadConfig();
}

/*-------------------------------------------------------------------*/
/*!

*/
DebugMessageFrame::~DebugMessageFrame()
{
    //std::cerr << "delete DebugMessageFrame" << std::endl;
    saveConfig();
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::clear()
{
    M_debug_holder = boost::shared_ptr< DebugLogHolder >( new DebugLogHolder );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::loadConfig()
{
    wxFileConfig & config_file = SoccerWindowApp::get_config_file();
    wxString old_path = config_file.GetPath();
    config_file.SetPath( wxT( "/DebugMessageFrame" ) );
    /////
    if ( this->GetToolBar() )
    {
        wxToolBar * tbar = this->GetToolBar();
        long value = 1;

        config_file.Read( wxT( "debug01" ), &value );
        tbar->ToggleTool( SWID_DEBUG_LEVEL_1, value );
        if ( value ) M_level |= DebugLogData::LEVEL_1;
        else  M_level &= ~DebugLogData::LEVEL_1;

        config_file.Read( wxT( "debug02" ), &value );
        tbar->ToggleTool( SWID_DEBUG_LEVEL_2, value );
        if ( value ) M_level |= DebugLogData::LEVEL_2;
        else  M_level &= ~DebugLogData::LEVEL_2;

        config_file.Read( wxT( "debug03" ), &value );
        tbar->ToggleTool( SWID_DEBUG_LEVEL_3, value );
        if ( value ) M_level |= DebugLogData::LEVEL_3;
        else  M_level &= ~DebugLogData::LEVEL_3;

        config_file.Read( wxT( "debug04" ), &value );
        tbar->ToggleTool( SWID_DEBUG_LEVEL_4, value );
        if ( value ) M_level |= DebugLogData::LEVEL_4;
        else  M_level &= ~DebugLogData::LEVEL_4;

        config_file.Read( wxT( "debug05" ), &value );
        tbar->ToggleTool( SWID_DEBUG_LEVEL_5, value );
        if ( value ) M_level |= DebugLogData::LEVEL_5;
        else  M_level &= ~DebugLogData::LEVEL_5;

        config_file.Read( wxT( "debug06" ), &value );
        tbar->ToggleTool( SWID_DEBUG_LEVEL_6, value );
        if ( value ) M_level |= DebugLogData::LEVEL_6;
        else  M_level &= ~DebugLogData::LEVEL_6;

        config_file.Read( wxT( "debug07" ), &value );
        tbar->ToggleTool( SWID_DEBUG_LEVEL_7, value );
        if ( value ) M_level |= DebugLogData::LEVEL_7;
        else  M_level &= ~DebugLogData::LEVEL_7;

        config_file.Read( wxT( "debug08" ), &value );
        tbar->ToggleTool( SWID_DEBUG_LEVEL_8, value );
        if ( value ) M_level |= DebugLogData::LEVEL_8;
        else  M_level &= ~DebugLogData::LEVEL_8;

        config_file.Read( wxT( "debug09" ), &value );
        tbar->ToggleTool( SWID_DEBUG_LEVEL_9, value );
        if ( value ) M_level |= DebugLogData::LEVEL_9;
        else  M_level &= ~DebugLogData::LEVEL_9;

        config_file.Read( wxT( "debug10" ), &value );
        tbar->ToggleTool( SWID_DEBUG_LEVEL_10, value );
        if ( value ) M_level |= DebugLogData::LEVEL_10;
        else  M_level &= ~DebugLogData::LEVEL_10;

        config_file.Read( wxT( "debug11" ), &value );
        tbar->ToggleTool( SWID_DEBUG_LEVEL_11, value );
        if ( value ) M_level |= DebugLogData::LEVEL_11;
        else  M_level &= ~DebugLogData::LEVEL_11;

        config_file.Read( wxT( "debug12" ), &value );
        tbar->ToggleTool( SWID_DEBUG_LEVEL_12, value );
        if ( value ) M_level |= DebugLogData::LEVEL_12;
        else  M_level &= ~DebugLogData::LEVEL_12;

        config_file.Read( wxT( "debug13" ), &value );
        tbar->ToggleTool( SWID_DEBUG_LEVEL_13, value );
        if ( value ) M_level |= DebugLogData::LEVEL_13;
        else  M_level &= ~DebugLogData::LEVEL_13;

        config_file.Read( wxT( "debug14" ), &value );
        tbar->ToggleTool( SWID_DEBUG_LEVEL_14, value );
        if ( value ) M_level |= DebugLogData::LEVEL_14;
        else  M_level &= ~DebugLogData::LEVEL_14;

        config_file.Read( wxT( "debug15" ), &value );
        tbar->ToggleTool( SWID_DEBUG_LEVEL_15, value );
        if ( value ) M_level |= DebugLogData::LEVEL_15;
        else  M_level &= ~DebugLogData::LEVEL_15;

        config_file.Read( wxT( "debug16" ), &value );
        tbar->ToggleTool( SWID_DEBUG_LEVEL_16, value );
        if ( value ) M_level |= DebugLogData::LEVEL_16;
        else  M_level &= ~DebugLogData::LEVEL_16;
    }
    /////
    config_file.SetPath( old_path );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::saveConfig()
{
    wxFileConfig & config_file = SoccerWindowApp::get_config_file();
    wxString old_path = config_file.GetPath();
    config_file.SetPath( wxT( "/DebugMessageFrame" ) );
    /////
    if ( this->GetToolBar() )
    {
        wxToolBar * tbar = this->GetToolBar();
        config_file.Write( wxT( "debug01" ),
                           tbar->GetToolState( SWID_DEBUG_LEVEL_1 ) ? 1L : 0L );
        config_file.Write( wxT( "debug02" ),
                           tbar->GetToolState( SWID_DEBUG_LEVEL_2 ) ? 1L : 0L );
        config_file.Write( wxT( "debug03" ),
                           tbar->GetToolState( SWID_DEBUG_LEVEL_3 ) ? 1L : 0L );
        config_file.Write( wxT( "debug04" ),
                           tbar->GetToolState( SWID_DEBUG_LEVEL_4 ) ? 1L : 0L );
        config_file.Write( wxT( "debug05" ),
                           tbar->GetToolState( SWID_DEBUG_LEVEL_5 ) ? 1L : 0L );
        config_file.Write( wxT( "debug06" ),
                           tbar->GetToolState( SWID_DEBUG_LEVEL_6 ) ? 1L : 0L );
        config_file.Write( wxT( "debug07" ),
                           tbar->GetToolState( SWID_DEBUG_LEVEL_7 ) ? 1L : 0L );
        config_file.Write( wxT( "debug08" ),
                           tbar->GetToolState( SWID_DEBUG_LEVEL_8 ) ? 1L : 0L );
        config_file.Write( wxT( "debug09" ),
                           tbar->GetToolState( SWID_DEBUG_LEVEL_9 ) ? 1L : 0L );
        config_file.Write( wxT( "debug10" ),
                           tbar->GetToolState( SWID_DEBUG_LEVEL_10 ) ? 1L : 0L );
        config_file.Write( wxT( "debug11" ),
                           tbar->GetToolState( SWID_DEBUG_LEVEL_11 ) ? 1L : 0L );
        config_file.Write( wxT( "debug12" ),
                           tbar->GetToolState( SWID_DEBUG_LEVEL_12 ) ? 1L : 0L );
        config_file.Write( wxT( "debug13" ),
                           tbar->GetToolState( SWID_DEBUG_LEVEL_13 ) ? 1L : 0L );
        config_file.Write( wxT( "debug14" ),
                           tbar->GetToolState( SWID_DEBUG_LEVEL_14 ) ? 1L : 0L );
        config_file.Write( wxT( "debug15" ),
                           tbar->GetToolState( SWID_DEBUG_LEVEL_15 ) ? 1L : 0L );
        config_file.Write( wxT( "debug16" ),
                           tbar->GetToolState( SWID_DEBUG_LEVEL_16 ) ? 1L : 0L );
    }
    /////
    config_file.SetPath( old_path );
}

/*-------------------------------------------------------------------*/
/*!
  creates dynamic event signal connect
*/
void
DebugMessageFrame::connectEvents()
{
    // ---------------------------------------------------
    // register wx event hander
    // close frame
    Connect( SWID_FRAME_DEBUG_MESSAGE, wxEVT_CLOSE_WINDOW,
             wxCloseEventHandler( DebugMessageFrame::handleCloseEvent ) );

    // notebook page change
    Connect( SWID_NOTEBOOK_DEBUG_MESSAGE, wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGED,
             wxNotebookEventHandler( DebugMessageFrame::handleNotebookPageChanged ) );

    // ---------------------------------------------------
    // register message hander

    M_main_frame->connect( SWID_SHOW_DEBUG_LOG_DIR_DIALOG,
                           this, &DebugMessageFrame::recvShowDebugLogDirDialog );

    M_main_frame->connect( SWID_DEBUG_LEVEL_1,
                           this, &DebugMessageFrame::recvDebugLevel1 );
    M_main_frame->connect( SWID_DEBUG_LEVEL_2,
                           this, &DebugMessageFrame::recvDebugLevel2 );
    M_main_frame->connect( SWID_DEBUG_LEVEL_3,
                           this, &DebugMessageFrame::recvDebugLevel3 );
    M_main_frame->connect( SWID_DEBUG_LEVEL_4,
                           this, &DebugMessageFrame::recvDebugLevel4 );
    M_main_frame->connect( SWID_DEBUG_LEVEL_5,
                           this, &DebugMessageFrame::recvDebugLevel5 );
    M_main_frame->connect( SWID_DEBUG_LEVEL_6,
                           this, &DebugMessageFrame::recvDebugLevel6 );
    M_main_frame->connect( SWID_DEBUG_LEVEL_7,
                           this, &DebugMessageFrame::recvDebugLevel7 );
    M_main_frame->connect( SWID_DEBUG_LEVEL_8,
                           this, &DebugMessageFrame::recvDebugLevel8 );
    M_main_frame->connect( SWID_DEBUG_LEVEL_9,
                           this, &DebugMessageFrame::recvDebugLevel9 );
    M_main_frame->connect( SWID_DEBUG_LEVEL_10,
                           this, &DebugMessageFrame::recvDebugLevel10 );
    M_main_frame->connect( SWID_DEBUG_LEVEL_11,
                           this, &DebugMessageFrame::recvDebugLevel11 );
    M_main_frame->connect( SWID_DEBUG_LEVEL_12,
                           this, &DebugMessageFrame::recvDebugLevel12 );
    M_main_frame->connect( SWID_DEBUG_LEVEL_13,
                           this, &DebugMessageFrame::recvDebugLevel13 );
    M_main_frame->connect( SWID_DEBUG_LEVEL_14,
                           this, &DebugMessageFrame::recvDebugLevel14 );
    M_main_frame->connect( SWID_DEBUG_LEVEL_15,
                           this, &DebugMessageFrame::recvDebugLevel15 );
    M_main_frame->connect( SWID_DEBUG_LEVEL_16,
                           this, &DebugMessageFrame::recvDebugLevel16 );

    M_main_frame->connect( SWID_DISPLAY_DEBUG_MESSAGE,
                           this, &DebugMessageFrame::recvDisplayDebugMessage );

    M_main_frame->connect( SWID_DEBUG_LOG_SYNC,
                           this, &DebugMessageFrame::recvDebugLogSync );
    M_main_frame->connect( SWID_DEBUG_LOG_DECREMENT,
                           this, &DebugMessageFrame::recvDebugLogDecrement );
    M_main_frame->connect( SWID_DEBUG_LOG_INCREMENT,
                           this, &DebugMessageFrame::recvDebugLogIncrement );
}


/*-------------------------------------------------------------------*/
/*!
  \brief create all windows that has this mainframe as a parent
*/
void
DebugMessageFrame::createWindows()
{
    createMenuBar();
    createToolBar();

    wxNotebook * notebook = new wxNotebook( this, SWID_NOTEBOOK_DEBUG_MESSAGE );


    for ( int i = 0; i < 11; ++i )
    {
        M_message[i] = new wxTextCtrl( notebook,
                                       SWID_TEXTBOX_DEBUG_MESSAGE_1 + i,
                                       wxT( "" ),
                                       wxDefaultPosition, wxDefaultSize,
                                       wxTE_READONLY | wxTE_MULTILINE );
        wxString number;
        number.Printf( wxT( "   %2d " ), i + 1 );
        notebook->AddPage( M_message[i], number );
    }

#if wxCHECK_VERSION(2, 6, 0)
    // wxNotebookSizer is removed if wxWidgets version is higher than 2.6.0,
    // because wxNotebookSizer is deprecated.
#else
    wxNotebookSizer * sizer = new wxNotebookSizer( notebook );
    this->SetSizer( sizer );
    this->SetAutoLayout( true );
#endif

    // set minimal window size
    this->SetSizeHints( 280, 220 );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::createMenuBar()
{
    // create menu
    //wxMenuBar * menubar = new wxMenuBar;
    // append menubar to MainFrame.
    //this->SetMenuBar( menubar );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::createToolBar()
{
    wxToolBar * tbar = this->CreateToolBar( wxTB_HORIZONTAL
                                            | wxTB_FLAT
                                            );
    const ViewConfig & conf = M_data.config();

    ////////////////////////////////////////////////////////
    // visual debugger switches
    tbar->AddCheckTool( SWID_CANVAS_DRAW_DEBUG_VIEW,
                        _( "Switch" ),
                        wxBitmap( debug_view_all_xpm ),
                        wxNullBitmap,
                        _( "Show/Hide all debug view" ) );
    tbar->ToggleTool(  SWID_CANVAS_DRAW_DEBUG_VIEW,
                       conf.isShownDebugView() );
    tbar->AddCheckTool( SWID_CANVAS_DRAW_DEBUG_VIEW_SELF,
                        wxT( "Self" ),
                        wxBitmap( debug_view_self_xpm ),
                        wxNullBitmap,
                        _( "Show/Hide self" ) );
    tbar->ToggleTool( SWID_CANVAS_DRAW_DEBUG_VIEW_SELF,
                      conf.isShownDebugViewSelf() );
    tbar->AddCheckTool( SWID_CANVAS_DRAW_DEBUG_VIEW_BALL,
                        wxT( "Ball" ),
                        wxBitmap( debug_view_ball_xpm ),
                        wxNullBitmap,
                        _( "Show/Hide ball" ) );
    tbar->ToggleTool( SWID_CANVAS_DRAW_DEBUG_VIEW_BALL,
                      conf.isShownDebugViewBall() );
    tbar->AddCheckTool( SWID_CANVAS_DRAW_DEBUG_VIEW_PLAYERS,
                        wxT( "Player" ),
                        wxBitmap( debug_view_player_xpm ),
                        wxNullBitmap,
                        _( "Show/Hide other players" ) );
    tbar->ToggleTool( SWID_CANVAS_DRAW_DEBUG_VIEW_PLAYERS,
                      conf.isShownDebugViewPlayers() );
    tbar->AddCheckTool( SWID_CANVAS_DRAW_DEBUG_VIEW_COMMENT,
                        wxT( "Comment" ),
                        wxBitmap( debug_view_comment_xpm ),
                        wxNullBitmap,
                        _( "Show/Hide comment" ) );
    tbar->ToggleTool( SWID_CANVAS_DRAW_DEBUG_VIEW_COMMENT,
                      conf.isShownDebugViewComment() );
    tbar->AddCheckTool( SWID_CANVAS_DRAW_DEBUG_VIEW_FIGURE,
                        wxT( "Line" ),
                        wxBitmap( debug_view_line_xpm ),
                        wxNullBitmap,
                        _( "Show/Hide debug line" ) );
    tbar->ToggleTool( SWID_CANVAS_DRAW_DEBUG_VIEW_FIGURE,
                      conf.isShownDebugViewFigure() );
    tbar->AddCheckTool( SWID_CANVAS_DRAW_DEBUG_VIEW_TARGET,
                        wxT( "Target" ),
                        wxBitmap( debug_view_target_xpm ),
                        wxNullBitmap,
                        _( "Show/Hide target" ) );
    tbar->ToggleTool( SWID_CANVAS_DRAW_DEBUG_VIEW_TARGET,
                      conf.isShownDebugViewTarget() );
    tbar->AddCheckTool( SWID_CANVAS_DRAW_DEBUG_VIEW_MESSAGE,
                        wxT( "Message" ),
                        wxBitmap( debug_view_message_xpm ),
                        wxNullBitmap,
                        _( "Show/Hide debug message" ) );
    tbar->ToggleTool( SWID_CANVAS_DRAW_DEBUG_VIEW_MESSAGE,
                      conf.isShownDebugViewMessage() );
    tbar->AddSeparator();
    ////////////////////////////////////////////////////////
    // dir selector
    tbar->AddTool( SWID_SHOW_DEBUG_LOG_DIR_DIALOG,
                   wxT( "Open Dir" ),
                   wxBitmap( open_dir_xpm ),
                   _( "Open debug log directory" ) );
    tbar->AddSeparator();
    ////////////////////////////////////////////////////////
    // log message switch

    tbar->AddTool( SWID_DEBUG_LOG_SYNC,
                   wxT( "Sync" ),
                   wxBitmap( sync_xpm ),
                   _( "Synchronize with field canvas" ) );
    tbar->AddTool( SWID_DEBUG_LOG_DECREMENT,
                   wxT( "Decrement" ),
                   wxBitmap( logplayer_one_step_back_xpm ),
                   _( "Decremet message cycle" ) );
    tbar->AddTool( SWID_DEBUG_LOG_INCREMENT,
                   wxT( "Increment" ),
                   wxBitmap( logplayer_one_step_forward_xpm ),
                   _( "Increment message cycle" ) );

    tbar->AddSeparator();
    ////////////////////////////////////////////////////////

    // log level selector
    tbar->AddCheckTool( SWID_DEBUG_LEVEL_1, _( "Level 1" ),
                        wxBitmap( num_1_xpm ), wxNullBitmap,
                        _( "Debug Level 1 System" ) );
    tbar->ToggleTool( SWID_DEBUG_LEVEL_1, M_level & DebugLogData::LEVEL_1 );
    tbar->AddCheckTool( SWID_DEBUG_LEVEL_2, _( "Level 2" ),
                        wxBitmap( num_2_xpm ), wxNullBitmap,
                        _( "Debug Level 2 Sensor" ) );
    tbar->ToggleTool( SWID_DEBUG_LEVEL_2, M_level & DebugLogData::LEVEL_2 );
    tbar->AddCheckTool( SWID_DEBUG_LEVEL_3, _( "Level 3" ),
                        wxBitmap( num_3_xpm ), wxNullBitmap,
                        _( "Debug Level 3 WorldModel" ) );
    tbar->ToggleTool( SWID_DEBUG_LEVEL_3, M_level & DebugLogData::LEVEL_3 );
    tbar->AddCheckTool( SWID_DEBUG_LEVEL_4, _( "Level 4" ),
                        wxBitmap( num_4_xpm ), wxNullBitmap,
                        _( "Debug Level 4 BasicAction" ) );
    tbar->ToggleTool( SWID_DEBUG_LEVEL_4, M_level & DebugLogData::LEVEL_4 );
    tbar->AddCheckTool( SWID_DEBUG_LEVEL_5, _( "Level 5" ),
                        wxBitmap( num_5_xpm ), wxNullBitmap,
                        _( "Debug Level 5 Intercept" ) );
    tbar->ToggleTool( SWID_DEBUG_LEVEL_5, M_level & DebugLogData::LEVEL_5 );
    tbar->AddCheckTool( SWID_DEBUG_LEVEL_6, _( "Level 6" ),
                        wxBitmap( num_6_xpm ), wxNullBitmap,
                        _( "Debug Level 6 Kick" ) );
    tbar->ToggleTool( SWID_DEBUG_LEVEL_6, M_level & DebugLogData::LEVEL_6 );
    tbar->AddCheckTool( SWID_DEBUG_LEVEL_7, _( "Level 7" ),
                        wxBitmap( num_7_xpm ), wxNullBitmap,
                        _( "Debug Level 7 Dribble" ) );
    tbar->ToggleTool( SWID_DEBUG_LEVEL_7, M_level & DebugLogData::LEVEL_7 );
    tbar->AddCheckTool( SWID_DEBUG_LEVEL_8, _( "Level 8" ),
                        wxBitmap( num_8_xpm ), wxNullBitmap,
                        _( "Debug Level 8 Pass" ) );
    tbar->ToggleTool( SWID_DEBUG_LEVEL_8, M_level & DebugLogData::LEVEL_8 );
    tbar->AddCheckTool( SWID_DEBUG_LEVEL_9, _( "Level 9" ),
                        wxBitmap( num_9_xpm ), wxNullBitmap,
                        _( "Debug Level 9 Cross" ) );
    tbar->ToggleTool( SWID_DEBUG_LEVEL_9, M_level & DebugLogData::LEVEL_9 );
    tbar->AddCheckTool( SWID_DEBUG_LEVEL_10, _( "Level 10" ),
                        wxBitmap( num_10_xpm ), wxNullBitmap,
                        _( "Debug Level 10 Shoot" ) );
    tbar->ToggleTool( SWID_DEBUG_LEVEL_10, M_level & DebugLogData::LEVEL_10 );
    tbar->AddCheckTool( SWID_DEBUG_LEVEL_11, _( "Level 11" ),
                        wxBitmap( num_11_xpm ), wxNullBitmap,
                        _( "Debug Level 11 Clear" ) );
    tbar->ToggleTool( SWID_DEBUG_LEVEL_11, M_level & DebugLogData::LEVEL_11 );
    tbar->AddCheckTool( SWID_DEBUG_LEVEL_12, _( "Level 12" ),
                        wxBitmap( num_12_xpm ), wxNullBitmap,
                        _( "Debug Level 12 Team" ) );
    tbar->ToggleTool( SWID_DEBUG_LEVEL_12, M_level & DebugLogData::LEVEL_12 );
    tbar->AddCheckTool( SWID_DEBUG_LEVEL_13, _( "Level 13" ),
                        wxBitmap( num_13_xpm ), wxNullBitmap,
                        _( "Debug Level 13 Role" ) );
    tbar->ToggleTool( SWID_DEBUG_LEVEL_13, M_level & DebugLogData::LEVEL_13 );
    tbar->AddCheckTool( SWID_DEBUG_LEVEL_14, _( "Level 14" ),
                        wxBitmap( num_14_xpm ), wxNullBitmap,
                        _( "Debug Level 14" ) );
    tbar->ToggleTool( SWID_DEBUG_LEVEL_14, M_level & DebugLogData::LEVEL_14 );
    tbar->AddCheckTool( SWID_DEBUG_LEVEL_15, _( "Level 15" ),
                        wxBitmap( num_15_xpm ), wxNullBitmap,
                        _( "Debug Level 15" ) );
    tbar->ToggleTool( SWID_DEBUG_LEVEL_15, M_level & DebugLogData::LEVEL_15 );
    tbar->AddCheckTool( SWID_DEBUG_LEVEL_16, _( "Level 16" ),
                        wxBitmap( num_16_xpm ), wxNullBitmap,
                        _( "Debug Level 16" ) );
    tbar->ToggleTool( SWID_DEBUG_LEVEL_16, M_level & DebugLogData::LEVEL_16 );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::showDebugLogDirDialog()
{
    DebugLogDirDialog dlg( this );

    if ( dlg.ShowModal() != wxID_OK )
    {
        //std::cerr << "DebugLogDirDialog is not ok." << std::endl;
        return;
    }

    rcsc::SideID side = dlg.getSide();
    std::string dir_path = dlg.getDirPath();

    std::cerr << "Select side = "
              << ( side == rcsc::LEFT ? "left" : "right" )
              << "  debug log dir = [" << dir_path << "]"
              << std::endl;
    AppConfig::instance().setDebugLogDir( dir_path );

    loadDebugLogDir( side, dir_path );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::update()
{
    if ( M_selection < 0 || 11 < M_selection )
    {
        return;
    }

    const DebugLogHolder::DataList * data_list = M_debug_holder->getDataList( M_selection + 1 );
    if ( ! data_list )
    {
        return;
    }

    if ( M_level == 0 )
    {
        return;
    }

    const long cur_cycle = M_debug_holder->getCurrentCycle();

    wxTextCtrl * textctrl = M_message[M_selection];

    // clear current data
    textctrl->Clear();

    wxString main_buffer;
    main_buffer.Alloc( 1000 * 256 );
    int n_line = 0;

    long show_pos = 0;
    const DebugLogHolder::DataList::const_iterator data_end = data_list->end();
    for ( DebugLogHolder::DataList::const_iterator data_it = data_list->begin();
          data_it != data_end;
          ++data_it )
    {
        if ( ! (*data_it) )
        {
            std::cerr << __FILE__ << ":" << __LINE__
                      << " Null data found!" << std::endl;
            continue;
        }

        if ( (*data_it)->getCycle() <= cur_cycle )
        {
            show_pos = textctrl->GetLastPosition();
        }

        wxString cycle_line;
        cycle_line.Printf( wxT( "CYCLE %ld ------------------------------\n" ),
                           (*data_it)->getCycle() );
        textctrl->AppendText( cycle_line );

        const DebugLogData::TextList::const_iterator text_end = (*data_it)->getTextList().end();
        for ( DebugLogData::TextList::const_iterator text_it = (*data_it)->getTextList().begin();
              text_it != text_end;
              ++text_it )
        {
            // level check
            //if ( lfirst <= text_it->first
            //&& text_it->first <= llast )
            if ( M_level & text_it->first )
            {
                main_buffer += text_it->second;
                if ( ++n_line > 1000 )
                {
                    // append message to text control
                    //textctrl->AppendText( text_it->second );
                    textctrl->AppendText( main_buffer );
                    main_buffer.Empty();
                    n_line = 0;
                }
            }
        }
        if ( ! main_buffer.IsEmpty() )
        {
            textctrl->AppendText( main_buffer );
            main_buffer.Empty();
        }
    }

    textctrl->ShowPosition( show_pos );
}

/*-------------------------------------------------------------------*/
/*!
  close event handler.
*/
void
DebugMessageFrame::handleCloseEvent( wxCloseEvent & WXUNUSED( event ) )
{
    if ( this->GetParent() )
    {
        this->Hide();
    }
    else
    {
        this->Destroy();
    }
}

/*-------------------------------------------------------------------*/
/*!
  notebook page changed event handler
*/
void
DebugMessageFrame::handleNotebookPageChanged( wxNotebookEvent & event )
{
    /*
      std::cerr << "Notebook page changed. from = "
      << event.GetOldSelection()
      << " to " << event.GetSelection() << std::endl;
    */
    M_selection = event.GetSelection();
    M_main_frame->handle( EventMessage( SWID_DEBUG_LOG_SYNC ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDebugLevel1( const boost::any * )
{
    M_level ^= DebugLogData::LEVEL_1; // reverse only 1 bit
    M_main_frame->handle( EventMessage( SWID_DISPLAY_DEBUG_MESSAGE ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDebugLevel2( const boost::any * )
{
    M_level ^= DebugLogData::LEVEL_2;
    M_main_frame->handle( EventMessage( SWID_DISPLAY_DEBUG_MESSAGE ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDebugLevel3( const boost::any * )
{
    M_level ^= DebugLogData::LEVEL_3;
    M_main_frame->handle( EventMessage( SWID_DISPLAY_DEBUG_MESSAGE ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDebugLevel4( const boost::any * )
{
    M_level ^= DebugLogData::LEVEL_4;
    M_main_frame->handle( EventMessage( SWID_DISPLAY_DEBUG_MESSAGE ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDebugLevel5( const boost::any * )
{
    M_level ^= DebugLogData::LEVEL_5;
    M_main_frame->handle( EventMessage( SWID_DISPLAY_DEBUG_MESSAGE ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDebugLevel6( const boost::any * )
{
    M_level ^= DebugLogData::LEVEL_6;
    M_main_frame->handle( EventMessage( SWID_DISPLAY_DEBUG_MESSAGE ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDebugLevel7( const boost::any * )
{
    M_level ^= DebugLogData::LEVEL_7;
    M_main_frame->handle( EventMessage( SWID_DISPLAY_DEBUG_MESSAGE ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDebugLevel8( const boost::any * )
{
    M_level ^= DebugLogData::LEVEL_8;
    M_main_frame->handle( EventMessage( SWID_DISPLAY_DEBUG_MESSAGE ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDebugLevel9( const boost::any * )
{
    M_level ^= DebugLogData::LEVEL_9;
    M_main_frame->handle( EventMessage( SWID_DISPLAY_DEBUG_MESSAGE ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDebugLevel10( const boost::any * )
{
    // use x-or to change only one bit
    M_level ^= DebugLogData::LEVEL_10;
    M_main_frame->handle( EventMessage( SWID_DISPLAY_DEBUG_MESSAGE ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDebugLevel11( const boost::any * )
{
    // use x-or to change only one bit
    M_level ^= DebugLogData::LEVEL_11;
    M_main_frame->handle( EventMessage( SWID_DISPLAY_DEBUG_MESSAGE ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDebugLevel12( const boost::any * )
{
    // use x-or to change only one bit
    M_level ^= DebugLogData::LEVEL_12;
    M_main_frame->handle( EventMessage( SWID_DISPLAY_DEBUG_MESSAGE ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDebugLevel13( const boost::any * )
{
    // use x-or to change only one bit
    M_level ^= DebugLogData::LEVEL_13;
    M_main_frame->handle( EventMessage( SWID_DISPLAY_DEBUG_MESSAGE ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDebugLevel14( const boost::any * )
{
    // use x-or to change only one bit
    M_level ^= DebugLogData::LEVEL_14;
    M_main_frame->handle( EventMessage( SWID_DISPLAY_DEBUG_MESSAGE ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDebugLevel15( const boost::any * )
{
    // use x-or to change only one bit
    M_level ^= DebugLogData::LEVEL_15;
    M_main_frame->handle( EventMessage( SWID_DISPLAY_DEBUG_MESSAGE ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDebugLevel16( const boost::any * )
{
    // use x-or to change only one bit
    M_level ^= DebugLogData::LEVEL_16;
    M_main_frame->handle( EventMessage( SWID_DISPLAY_DEBUG_MESSAGE ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDisplayDebugMessage( const boost::any * )
{
    update();
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDebugLogSync( const boost::any * )
{
    const MonitorViewPtr ptr = M_data.getCurrentViewData();
    if ( ! ptr )
    {
        return;
    }

    std::cerr << "sync debug data cycle" << std::endl;
    // seek current cycle data
    if ( ! M_debug_holder->seekData( M_selection + 1, ptr->cycle() ) )
    {
        std::cerr << "No data! number = "
                  << M_selection +1
                  << std::endl;
        return;
    }

    M_main_frame->handle( EventMessage( SWID_DISPLAY_DEBUG_MESSAGE ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDebugLogDecrement( const boost::any * )
{
    if ( ! M_debug_holder->decDataCycle( M_selection + 1 ) )
    {
        return;
    }

    M_main_frame->handle( EventMessage( SWID_DISPLAY_DEBUG_MESSAGE ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::recvDebugLogIncrement( const boost::any * )
{
    if ( ! M_debug_holder->incDataCycle( M_selection + 1 ) )
    {
        std::cerr << "Failed increment debug log" << std::endl;
        return;
    }

    M_main_frame->handle( EventMessage( SWID_DISPLAY_DEBUG_MESSAGE ) );
}


/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::setCycle( const long & cycle )
{
    M_debug_holder->seekData( M_selection + 1, cycle );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::loadDebugLogDir( const rcsc::SideID side,
                                    const std::string & dir_path )
{
    const MonitorViewPtr ptr = M_data.getCurrentViewData();
    if ( ! ptr )
    {
        std::cerr << "No valid data!" << std::endl;
        return;
    }

    if ( ptr->leftTeam().name().empty() )
    {
        std::cerr << "Empty team name!" << std::endl;
        return;
    }

    if ( side == rcsc::LEFT )
    {
        if ( M_debug_holder->setDir( ptr->leftTeam().name(),
                                     M_selection + 1,
                                     dir_path ) )
        {
            M_main_frame->handle( EventMessage( SWID_DEBUG_LOG_SYNC ) );
        }
    }
    else if ( side == rcsc::RIGHT )
    {
        if ( M_debug_holder->setDir( ptr->rightTeam().name(),
                                     M_selection + 1,
                                     dir_path ) )
        {
            M_main_frame->handle( EventMessage( SWID_DEBUG_LOG_SYNC ) );
        }
    }
}


/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::setShowDebugView()
{

}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::setShowDebugViewSelf()
{

}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::setShowDebugViewBall()
{

}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::setShowDebugViewPlayers()
{

}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::setShowDebugViewComment()
{

}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::setShowDebugViewFigure()
{

}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::setShowDebugViewTarget()
{

}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugMessageFrame::setShowDebugViewMessage()
{

}
