// -*-c++-*-

/*!
  \file ball.cpp
  \brief ball data class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#include <rcsc/rcg/util.h>

#include "ball.h"

/*-------------------------------------------------------------------*/
/*!
  sets default values only
*/
Ball::Ball()
    : M_have_delta( false )
{
    M_data.x = 0;
    M_data.y = 0;
    M_data.deltax = 0;
    M_data.deltay = 0;
}

/*-------------------------------------------------------------------*/
/*!
  assign new data.
*/
void
Ball::assign( const rcsc::rcg::ball_t & ball )
{
    M_data.x = ntohl( ball.x );
    M_data.y = ntohl( ball.y );
    M_data.deltax = ntohl( ball.deltax );
    M_data.deltay = ntohl( ball.deltay );

    M_have_delta = true;
}

/*-------------------------------------------------------------------*/
/*!
  assign new data.
*/
void
Ball::assign( const rcsc::rcg::pos_t & p )
{
    M_data.x = static_cast< long >
        ( static_cast< double >( static_cast< short >( ntohs( p.x ) ) )
          * ( rcsc::rcg::SHOWINFO_SCALE2 / rcsc::rcg::SHOWINFO_SCALE ) );
    M_data.y =  static_cast< long >
        ( static_cast< double >( static_cast< short >( ntohs( p.y ) ) )
          * ( rcsc::rcg::SHOWINFO_SCALE2 / rcsc::rcg::SHOWINFO_SCALE ) );
    M_data.deltax = 0;
    M_data.deltay = 0;

    M_have_delta = false;
}
