// -*-c++-*-

/*!
  \file player.h
  \brief player agent Header File
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef RCSC_PLAYER_H
#define RCSC_PLAYER_H

#include <rcsc/player/action_effector.h>
#include <rcsc/player/audio_codec.h>
#include <rcsc/player/audio_sensor.h>
#include <rcsc/player/ball_object.h>
#include <rcsc/player/body_sensor.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/player/fullstate_sensor.h>
#include <rcsc/player/intercept_table.h>
#include <rcsc/player/interception.h>
#include <rcsc/player/localization.h>
#include <rcsc/player/logger.h>
#include <rcsc/player/object_table.h>
#include <rcsc/player/penalty_kick_state.h>
#include <rcsc/player/player_agent.h>
#include <rcsc/player/player_command.h>
#include <rcsc/player/player_config.h>
#include <rcsc/player/player_intercept.h>
#include <rcsc/player/player_object.h>
#include <rcsc/player/see_state.h>
#include <rcsc/player/self_intercept.h>
#include <rcsc/player/self_object.h>
#include <rcsc/player/soccer_action.h>
#include <rcsc/player/soccer_intention.h>
#include <rcsc/player/stamina_model.h>
#include <rcsc/player/view_mode.h>
#include <rcsc/player/visual_sensor.h>
#include <rcsc/player/world_model.h>

#endif
