// -*-c++-*-

/*!
  \file coach_config.cpp
  \brief coach configuration Source File
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <rcsc/param/param_map.h>

#include "coach_config.h"

namespace rcsc {

/*-------------------------------------------------------------------*/
/*!

*/
CoachConfig::CoachConfig()
{
    setDefaultParam();
}

/*-------------------------------------------------------------------*/
/*!

*/
CoachConfig::~CoachConfig()
{

    // std::cerr << "delete CoachConfig" << std::endl;
}

/*-------------------------------------------------------------------*/
/*!

*/
void
CoachConfig::setDefaultParam()
{
    // basic setting
    M_team_name = "HELIOS";
    M_version = 9.4;
    M_coach_name = "HELIOS_Coach";

    M_use_coach_name = false;

    M_interval_msec = 10;
    M_server_wait_seconds = 5;

    M_rcssserver_host = "localhost";
    M_rcssserver_port = 6002;

    M_use_eye = true;

    M_use_advise = true;
    M_use_freeform = true;

    M_use_hetero = true;
}

/*-------------------------------------------------------------------*/
/*!

*/
void
CoachConfig::createParamMap( ParamMap & param_map )
{
    param_map.add()
        ( &M_team_name, "team_name", "t" )
        ( &M_version, "version", "v" )

        ( &M_coach_name, "coach_name" )
        ( &M_use_coach_name, "use_coach_name" )

        ( &M_interval_msec, "interval_msec" )
        ( &M_server_wait_seconds, "server_wait_seconds" )

        ( &M_rcssserver_host, "host", "h" )
        ( &M_rcssserver_port, "port" )

        ( &M_use_eye, "use_eye" )

        ( &M_use_advise, "use_advise" )
        ( &M_use_freeform, "use_freeform" )

        ( &M_use_hetero, "use_hetero" )
        ;
}

}
