// -*-c++-*-

/*!
  \file action.h
  \brief player actions library Header File
*/

/*
 *Copyright:

 Copyright (C) Hidehisa Akiyama

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef RCSC_ACTION_H
#define RCSC_ACTION_H

#include <rcsc/action/bhv_before_kick_off.h>
#include <rcsc/action/bhv_body_neck_to_ball.h>
#include <rcsc/action/bhv_body_neck_to_point.h>
#include <rcsc/action/bhv_emergency.h>
#include <rcsc/action/bhv_go_to_point_look_ball.h>
#include <rcsc/action/bhv_neck_body_to_ball.h>
#include <rcsc/action/bhv_neck_body_to_point.h>
#include <rcsc/action/bhv_scan_field.h>
#include <rcsc/action/body_advance_ball.h>
#include <rcsc/action/body_clear_ball.h>
#include <rcsc/action/body_dribble.h>
#include <rcsc/action/body_go_to_point.h>
#include <rcsc/action/body_go_to_point_dodge.h>
#include <rcsc/action/body_hold_ball.h>
#include <rcsc/action/body_intercept.h>
#include <rcsc/action/body_kick_collide_with_ball.h>
#include <rcsc/action/body_kick_multi_step.h>
#include <rcsc/action/body_kick_one_step.h>
#include <rcsc/action/body_kick_to_relative.h>
#include <rcsc/action/body_kick_two_step.h>
#include <rcsc/action/body_pass.h>
#include <rcsc/action/body_shoot.h>
#include <rcsc/action/body_stop_ball.h>
#include <rcsc/action/body_stop_dash.h>
#include <rcsc/action/body_turn_to_angle.h>
#include <rcsc/action/body_turn_to_ball.h>
#include <rcsc/action/body_turn_to_point.h>
#include <rcsc/action/intention_dribble.h>
#include <rcsc/action/intention_kick.h>
#include <rcsc/action/intention_time_limit_action.h>
#include <rcsc/action/neck_scan_field.h>
#include <rcsc/action/neck_turn_to_ball.h>
#include <rcsc/action/neck_turn_to_ball_or_scan.h>
#include <rcsc/action/neck_turn_to_goalie_or_scan.h>
#include <rcsc/action/neck_turn_to_low_conf_teammate.h>
#include <rcsc/action/neck_turn_to_point.h>
#include <rcsc/action/neck_turn_to_relative.h>
#include <rcsc/action/view_normal.h>
#include <rcsc/action/view_synch.h>
#include <rcsc/action/view_wide.h>

#endif
