/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.util.xml.parse;

import java.io.IOException;
import org.util.xml.parse.ElementParser;

/**
 *
 * @author masaru
 */
public class AttValueParser extends ParseElement {

    String return_value_;
    
    @Override
    public boolean match(char c) {
        return allow(c);
    }

    @Override
        public int parse(int c, ElementParser parser) throws XMLParseException, IOException {
        StringBuffer sb = new StringBuffer();
        int next_word_ = -1;
        int state = 0;
        while(true) {
            if(c==-1) throw new XMLParseException("end of stream.");
            if(state == 0) {
                if(c=='\"') state = 1;
                else if(c=='\'') state = 2;
                else if(allow(c)) {
                    sb.append((char)c);
                    state = 3;
                } else throw new XMLParseException("parse error: cannot read value: this char does not allowed "+(char)c);
            }else if(state == 1) {
                if(c=='\"') state = 4;
                else sb.append((char)c);
            }else if(state == 2) {
                if(c=='\'') state = 4;
                else sb.append((char)c);
            }else if(state == 3) {
                if(allow(c)) sb.append((char)c);
                else {
                    next_word_ = c;
                    break;
                }
            }else if(state == 4) {
                next_word_ = c;
                break;
            }
            c = parser.get();
        }
        return_value_ = sb.toString();
        return next_word_;
    }

    @Override
    public String getReturnValue() {
        return return_value_;
    }
    
    public boolean allow(int c) {
        return (!isSpace(c) && (c!='<') && (c!='>') && (c!='!') && (c!=-1));
    }
}
