package org.util.xml;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.io.*;
import java.net.*;
import javax.swing.*;
import javax.swing.event.*;

import org.util.xml.element.*;
import org.util.xml.parse.*;
import org.util.xml.parse.policy.*;
import org.util.xml.renderer.html.*;


/**
 *
 * @author masaru
 */
public class Main4 {

	public static void main(String[] args) throws Exception {
		new Main4();
	}

	public Main4() throws Exception {
		String text = "<img src=\"http://www.google.com/intl/en_ALL/images/logo.gif\"/><div>aaabbbccc</div>";
//		ElementParser parser = new ElementParser(new StringReader(text));
//		ElementParser parser = new ElementParser(new URL("http://sakura.meijo-u.ac.jp/index.html").openStream());

//		URL url = new URL("http://www.google.com/index.html");
//		URL url = new URL("http://video.google.com/?hl=ja&tab=wv");
		URL url = new URL("http://sakura.meijo-u.ac.jp/index.html");
		ElementParser parser = new ElementParser(url.openStream());
		parser.setDocumentBase(url.toURI());
		
		final HTMLObject htmlo = new HTMLObject();
		parser.setPolicy(htmlo);
		parser.parse();
		
		final JComponent comp = new JComponent() {
			public void paint(Graphics g) {
				htmlo.paint(g);
			}
		};
		comp.addMouseListener(new MouseListener(){
			public void mousePressed(MouseEvent e) {
				if(htmlo.hit(e.getX(), e.getY()))
					htmlo.mousePressed(e);
			}
			public void mouseReleased(MouseEvent e) {
				if(htmlo.hit(e.getX(), e.getY()))
					htmlo.mouseReleased(e);
			}
			public void mouseClicked(MouseEvent e) {
				if(htmlo.hit(e.getX(), e.getY()))
					htmlo.mouseClicked(e);
			}
			public void mouseEntered(MouseEvent e) {
				if(htmlo.hit(e.getX(), e.getY()))
					htmlo.mouseEntered(e);
			}
			public void mouseExited(MouseEvent e) {
				if(htmlo.hit(e.getX(), e.getY()))
					htmlo.mouseExited(e);
			}
		});
		comp.addMouseMotionListener(new MouseMotionListener(){
			public void mouseMoved(MouseEvent e) {
				if(htmlo.hit(e.getX(), e.getY())) {
					htmlo.mouseMoved(e);
					if(!htmlo.is_mouse_over_) {
						htmlo.is_mouse_over_ = true;
						htmlo.mouseEntered(e);
					}
				} else {
					if(htmlo.is_mouse_over_) {
						htmlo.is_mouse_over_ = false;
						htmlo.mouseExited(e);
					}
				}
			}
			public void mouseDragged(MouseEvent e) {
				if(htmlo.hit(e.getX(), e.getY()))
					htmlo.mouseDragged(e);
			}
		});
		comp.addMouseWheelListener(new MouseWheelListener(){
			public void mouseWheelMoved(MouseWheelEvent e) {
				htmlo.mouseWheelMoved(e);
			}
		});

		htmlo.addChangeListener(new ChangeListener(){
			public void stateChanged(ChangeEvent e) {
				comp.repaint();
			}
		});

		JPanel panel = new JPanel(new BorderLayout());
		panel.add(comp, BorderLayout.CENTER);
		
		JFrame frame = new JFrame();
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setContentPane(panel);
		frame.pack();
		frame.setBounds(100,100, 500, 500);
		frame.setVisible(true);
		
	}
}
