package org.util.html.objects;


import java.util.*;
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

import org.util.xml.parse.policy.*;
import org.util.xml.element.*;

public abstract class HTMLObject implements ParserPolicy {

    private HTMLDocument root_;
    private boolean is_layouted_;
    private int next_x_, next_y_;
    private int height_;
    
    public HTMLObject(HTMLDocument root) {
	root_ = root;
    }
    public HTMLDocument getRoot() {
	return root_;
    }
    public void setLayouted(boolean is_layouted) {
	is_layouted_ = is_layouted;
    }
    public boolean isLayouted() {
	return is_layouted_;
    }

    public int getNextX() {
	return next_x_;
    }
    public int getNextY() {
	return next_y_;
    }
    public void setNextXY(int next_x, int next_y) {
	next_x_ = next_x;
	next_y_ = next_y;
    }

    public abstract JComponent getPanel();

    protected String[] forse_empty_tag_list_ = {"br","hr","meta","link","img","input","base","dd","dt","frame","p","pre","li","space"};

    public Element allowElement(Element element) {
	return element;
    }
    public boolean checkEndTag() {
	return true;
    }
    public boolean forceEmptyTag(String key) {
	for(int i=0;i<forse_empty_tag_list_.length;i++)
	    if(forse_empty_tag_list_[i].equals(key.toLowerCase()))
		return true;
	return false;
    }
    public ParserPolicy getInnerPolicy(Element element) {
	return this;
    }
    public String selectEncoding(java.lang.String last_tag_key) {
	return "utf-8";
    }
    public boolean throwExceptionIfDocumentHasError() {
	return false;
    }
    public boolean finished() {
	return false;
    }
}
