/*
 * Decompiled with CFR 0.152.
 */
package traffic3.simulator;

import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.ContinuousUniformGenerator;
import rescuecore2.config.Config;

public final class TrafficConstants {
    private static final double NUDGE_MAGNITUDE = 0.001;
    private static final double AGENT_FORCE_COEFFICIENT_A = 1.0E-4;
    private static final double AGENT_FORCE_COEFFICIENT_B = 0.001;
    private static final double AGENT_FORCE_COEFFICIENT_K = 1.0E-5;
    private static final double AGENT_DISTANCE_CUTOFF = 10000.0;
    private static final double AGENT_FORCE_LIMIT = 1.0E-4;
    private static NumberGenerator<Double> nudge;
    private static final double WALL_DISTANCE_CUTOFF = 2000.0;
    private static final double WALL_FORCE_COEFFICIENT_A = 0.01;
    private static final double WALL_FORCE_COEFFICIENT_B = 0.7;

    private TrafficConstants() {
    }

    static void init(Config config) {
        nudge = new ContinuousUniformGenerator(-0.001, 0.001, config.getRandom());
    }

    public static double getColocatedAgentNudge() {
        return (Double)nudge.nextValue();
    }

    public static double getAgentDistanceCutoff() {
        return 10000.0;
    }

    public static double getAgentForceCoefficientA() {
        return 1.0E-4;
    }

    public static double getAgentForceCoefficientB() {
        return 0.001;
    }

    public static double getAgentForceCoefficientK() {
        return 1.0E-5;
    }

    public static double getAgentForceLimit() {
        return 1.0E-4;
    }

    public static double getWallDistanceCutoff() {
        return 2000.0;
    }

    public static double getWallForceCoefficientA() {
        return 0.01;
    }

    public static double getWallForceCoefficientB() {
        return 0.7;
    }
}

