/*
 * Decompiled with CFR 0.152.
 */
package firesimulator.world;

import firesimulator.world.MovingObject;
import firesimulator.world.Refuge;

public class FireBrigade
extends MovingObject {
    public static int REFILL_QUANTITY;
    public static int MAX_WATER_QUANTITY;
    private int initialWaterQuantity = 0;
    private int waterQuantity = 0;
    private int waterUsed = 0;
    private boolean changed = false;

    public FireBrigade(int id) {
        super(id);
    }

    @Override
    public String getType() {
        return "FIRE_BRIGADE";
    }

    public void setInitialWaterQuantity(int quantity) {
        this.initialWaterQuantity = quantity;
        this.waterQuantity = quantity;
    }

    public int getWaterQuantity() {
        return this.waterQuantity;
    }

    public int getWaterUsed() {
        return this.waterUsed;
    }

    public void setWaterQuantity(int quantity) {
        this.waterQuantity = quantity;
        this.changed = true;
    }

    public void addWaterUsed(int quantity) {
        this.waterUsed += quantity;
    }

    public void nextCycle() {
        this.waterUsed = 0;
        this.changed = false;
    }

    public void reset() {
        this.waterQuantity = this.initialWaterQuantity;
        this.waterUsed = 0;
        this.changed = false;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public boolean refill() {
        if (!this.getCurrentAction().equals("AK_REST") || this.getLocation() == null || !this.getLocation().isRefuge()) {
            return false;
        }
        int fr = ((Refuge)this.getLocation()).getFieryness();
        if (fr == 3 || fr == 6 || fr == 7) {
            return false;
        }
        if (this.getWaterQuantity() + REFILL_QUANTITY > MAX_WATER_QUANTITY) {
            this.setWaterQuantity(MAX_WATER_QUANTITY);
        } else {
            this.setWaterQuantity(this.getWaterQuantity() + REFILL_QUANTITY);
        }
        return true;
    }
}

