/*
 * Decompiled with CFR 0.152.
 */
package handy.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderComponent
extends JPanel {
    private JSlider slider;
    private JTextField text;

    public SliderComponent(int min, int max, int value) {
        this(min, max, value, 1);
    }

    public SliderComponent(int min, int max, int value, int orientation) {
        this(new JSlider(orientation, min, max, value), new JTextField(String.valueOf(value)));
    }

    public SliderComponent(JSlider slider) {
        this(slider, new JTextField(String.valueOf(slider.getValue())));
    }

    public SliderComponent(JSlider slider, JTextField text) {
        super(new BorderLayout());
        this.setup(slider, text);
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public JTextField getTextField() {
        return this.text;
    }

    private void setup(JSlider s, JTextField t) {
        this.slider = s;
        this.text = t;
        this.add((Component)this.slider, "Center");
        this.text.setText(String.valueOf(this.slider.getValue()));
        if (this.slider.getOrientation() == 1) {
            this.add((Component)this.text, "South");
        } else {
            this.add((Component)this.text, "East");
        }
        this.text.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int i = Integer.parseInt(SliderComponent.this.text.getText());
                    SliderComponent.this.slider.setValue(i);
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SliderComponent.this.text.setText(String.valueOf(SliderComponent.this.slider.getValue()));
            }
        });
    }
}

