/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.scenario.ScenarioEditor;
import gis2.scenario.ShapeTool;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLBuilding;
import maps.gml.GMLShape;

public class PlaceFireTool
extends ShapeTool {
    public PlaceFireTool(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Place fire";
    }

    @Override
    protected boolean shouldHighlight(GMLShape shape) {
        return shape instanceof GMLBuilding;
    }

    @Override
    protected void processClick(GMLShape shape) {
        this.editor.getScenario().addFire(shape.getID());
        this.editor.setChanged();
        this.editor.updateOverlays();
        this.editor.addEdit(new AddFireEdit(shape.getID()));
    }

    private class AddFireEdit
    extends AbstractUndoableEdit {
        private int id;

        public AddFireEdit(int id) {
            this.id = id;
        }

        @Override
        public void undo() {
            super.undo();
            PlaceFireTool.this.editor.getScenario().removeFire(this.id);
            PlaceFireTool.this.editor.updateOverlays();
        }

        @Override
        public void redo() {
            super.redo();
            PlaceFireTool.this.editor.getScenario().addFire(this.id);
            PlaceFireTool.this.editor.updateOverlays();
        }
    }
}

