/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.worldmodel.properties;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rescuecore2.misc.EncodingTools;
import rescuecore2.worldmodel.AbstractProperty;
import rescuecore2.worldmodel.Property;

public class IntArrayProperty
extends AbstractProperty {
    private List<Integer> data;

    public IntArrayProperty(String urn) {
        super(urn);
        this.data = new ArrayList<Integer>();
    }

    public IntArrayProperty(Enum<?> urn) {
        super(urn);
        this.data = new ArrayList<Integer>();
    }

    public IntArrayProperty(String urn, int[] values) {
        super(urn, true);
        this.data = new ArrayList<Integer>(values.length);
        int[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer next = arr$[i$];
            this.data.add(next);
        }
    }

    public IntArrayProperty(Enum<?> urn, int[] values) {
        super(urn, true);
        this.data = new ArrayList<Integer>(values.length);
        int[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer next = arr$[i$];
            this.data.add(next);
        }
    }

    public IntArrayProperty(IntArrayProperty other) {
        super(other);
        this.data = new ArrayList<Integer>(other.data);
    }

    public int[] getValue() {
        if (!this.isDefined()) {
            return null;
        }
        Integer[] result = new Integer[this.data.size()];
        this.data.toArray(result);
        int[] out = new int[result.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = result[i];
        }
        return out;
    }

    public void setValue(int[] values) {
        int[] old = this.getValue();
        this.data = new ArrayList<Integer>(values.length);
        int[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer next = arr$[i$];
            this.data.add(next);
        }
        this.setDefined();
        this.fireChange(old, this.getValue());
    }

    public void push(int i) {
        int[] old = this.getValue();
        this.setDefined();
        this.data.add(i);
        this.fireChange(old, this.getValue());
    }

    @Override
    public void takeValue(Property p) {
        if (p instanceof IntArrayProperty) {
            IntArrayProperty i = (IntArrayProperty)p;
            if (i.isDefined()) {
                this.setValue(i.getValue());
            } else {
                this.undefine();
            }
        } else {
            throw new IllegalArgumentException(this + " cannot take value from " + p);
        }
    }

    @Override
    public void write(OutputStream out) throws IOException {
        EncodingTools.writeInt32(this.data.size(), out);
        for (Integer next : this.data) {
            EncodingTools.writeInt32((int)next, out);
        }
    }

    @Override
    public void read(InputStream in) throws IOException {
        int size = EncodingTools.readInt32(in);
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = EncodingTools.readInt32(in);
        }
        this.setValue(result);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getURN());
        if (this.isDefined()) {
            result.append(" = {");
            Iterator<Integer> it = this.data.iterator();
            while (it.hasNext()) {
                result.append(it.next());
                if (!it.hasNext()) continue;
                result.append(", ");
            }
            result.append("}");
        } else {
            result.append(" (undefined)");
        }
        return result.toString();
    }

    @Override
    public IntArrayProperty copy() {
        return new IntArrayProperty(this);
    }
}

