/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.score;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import rescuecore2.Timestep;
import rescuecore2.config.Config;
import rescuecore2.score.CompositeScoreFunction;
import rescuecore2.score.ScoreFunction;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.WorldModel;

public class CumulativeScoreFunction
extends CompositeScoreFunction {
    private Map<Integer, Double> scores;

    public CumulativeScoreFunction(String name) {
        super(name);
    }

    public CumulativeScoreFunction(String name, Collection<ScoreFunction> children) {
        super(name, children);
    }

    public CumulativeScoreFunction(String name, ScoreFunction ... children) {
        super(name, children);
    }

    @Override
    public void initialise(WorldModel<? extends Entity> world, Config config) {
        super.initialise(world, config);
        this.scores = new HashMap<Integer, Double>();
    }

    @Override
    public double score(WorldModel<? extends Entity> world, Timestep timestep) {
        double sum = 0.0;
        for (ScoreFunction next : this.children) {
            sum += next.score(world, timestep);
        }
        Double previous = this.scores.get(timestep.getTime() - 1);
        if (previous != null) {
            sum += previous.doubleValue();
        }
        this.scores.put(timestep.getTime(), sum);
        return sum;
    }
}

