/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.registry;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EnumSet;
import rescuecore2.registry.EntityFactory;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;

public abstract class AbstractEntityFactory<T extends Enum<T>>
implements EntityFactory {
    private Class<T> clazz;
    private Method fromString;

    protected AbstractEntityFactory(Class<T> clazz) {
        this.clazz = clazz;
        try {
            this.fromString = clazz.getDeclaredMethod("fromString", String.class);
        }
        catch (NoSuchMethodException e) {
            this.fromString = null;
        }
    }

    @Override
    public String[] getKnownEntityURNs() {
        EnumSet<T> set = this.getKnownEntityURNsEnum();
        String[] result = new String[set.size()];
        int i = 0;
        for (Enum next : set) {
            result[i++] = next.toString();
        }
        return result;
    }

    @Override
    public Entity makeEntity(String urn, EntityID id) {
        Enum t = null;
        if (this.fromString != null) {
            try {
                t = (Enum)this.fromString.invoke(null, urn);
            }
            catch (IllegalAccessException e) {
                t = null;
            }
            catch (InvocationTargetException e) {
                t = null;
            }
        }
        if (t == null) {
            t = (Enum)Enum.valueOf(this.clazz, urn);
        }
        return this.makeEntity(t, id);
    }

    protected EnumSet<T> getKnownEntityURNsEnum() {
        return EnumSet.allOf(this.clazz);
    }

    protected abstract Entity makeEntity(T var1, EntityID var2);
}

