/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.messages.control;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import rescuecore2.messages.AbstractMessage;
import rescuecore2.messages.Command;
import rescuecore2.messages.Control;
import rescuecore2.messages.components.ChangeSetComponent;
import rescuecore2.messages.components.CommandListComponent;
import rescuecore2.messages.components.EntityIDComponent;
import rescuecore2.messages.components.IntComponent;
import rescuecore2.messages.control.ControlMessageURN;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.EntityID;

public class KASense
extends AbstractMessage
implements Control {
    private EntityIDComponent agentID = new EntityIDComponent("Agent ID");
    private IntComponent time = new IntComponent("Time");
    private ChangeSetComponent updates = new ChangeSetComponent("Updates");
    private CommandListComponent hear = new CommandListComponent("Hearing");

    public KASense(InputStream in) throws IOException {
        this();
        this.read(in);
    }

    public KASense(EntityID agentID, int time, ChangeSet changes, Collection<? extends Command> hear) {
        this();
        this.agentID.setValue(agentID);
        this.time.setValue(time);
        this.updates.setChangeSet(changes);
        this.hear.setCommands(hear);
    }

    private KASense() {
        super(ControlMessageURN.KA_SENSE);
        this.addMessageComponent(this.agentID);
        this.addMessageComponent(this.time);
        this.addMessageComponent(this.updates);
        this.addMessageComponent(this.hear);
    }

    public EntityID getAgentID() {
        return this.agentID.getValue();
    }

    public int getTime() {
        return this.time.getValue();
    }

    public ChangeSet getChangeSet() {
        return this.updates.getChangeSet();
    }

    public Collection<Command> getHearing() {
        return this.hear.getCommands();
    }
}

