/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.messages.control;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import rescuecore2.messages.AbstractMessage;
import rescuecore2.messages.Control;
import rescuecore2.messages.components.EntityIDListComponent;
import rescuecore2.messages.components.IntComponent;
import rescuecore2.messages.control.ControlMessageURN;
import rescuecore2.worldmodel.EntityID;

public class EntityIDResponse
extends AbstractMessage
implements Control {
    private IntComponent simID = new IntComponent("Simulator ID");
    private IntComponent requestID = new IntComponent("Request number");
    private EntityIDListComponent newID = new EntityIDListComponent("New entity IDs");

    public EntityIDResponse(InputStream in) throws IOException {
        this();
        this.read(in);
    }

    public EntityIDResponse(int simID, int requestID, EntityID ... ids) {
        this(simID, requestID, Arrays.asList(ids));
    }

    public EntityIDResponse(int simID, int requestID, List<EntityID> ids) {
        this();
        this.simID.setValue(simID);
        this.requestID.setValue(requestID);
        this.newID.setIDs(ids);
    }

    private EntityIDResponse() {
        super(ControlMessageURN.ENTITY_ID_RESPONSE);
        this.addMessageComponent(this.simID);
        this.addMessageComponent(this.requestID);
        this.addMessageComponent(this.newID);
    }

    public List<EntityID> getEntityIDs() {
        return this.newID.getIDs();
    }

    public int getSimulatorID() {
        return this.simID.getValue();
    }

    public int getRequestID() {
        return this.requestID.getValue();
    }
}

