/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.log;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.log4j.LogManager;
import org.apache.log4j.NDC;

public final class Logger {
    private static final InheritableThreadLocal<Deque<org.apache.log4j.Logger>> LOG = new InheritableThreadLocal<Deque<org.apache.log4j.Logger>>(){

        @Override
        protected Deque<org.apache.log4j.Logger> initialValue() {
            return new ArrayDeque<org.apache.log4j.Logger>();
        }

        @Override
        protected Deque<org.apache.log4j.Logger> childValue(Deque<org.apache.log4j.Logger> parent) {
            return new ArrayDeque<org.apache.log4j.Logger>(parent);
        }
    };

    private Logger() {
    }

    public static void setLogContext(String context) {
        Deque queue = (Deque)LOG.get();
        queue.clear();
        queue.addLast(LogManager.getLogger((String)context));
    }

    public static void pushLogContext(String context) {
        Deque queue = (Deque)LOG.get();
        queue.addLast(LogManager.getLogger((String)context));
    }

    public static void popLogContext() {
        Deque queue = (Deque)LOG.get();
        queue.removeLast();
    }

    private static org.apache.log4j.Logger get() {
        Deque queue = (Deque)LOG.get();
        if (queue.isEmpty()) {
            return LogManager.getRootLogger();
        }
        return (org.apache.log4j.Logger)queue.getLast();
    }

    public static void pushNDC(String s) {
        NDC.push((String)s);
    }

    public static void popNDC() {
        NDC.pop();
    }

    public static void trace(String msg) {
        Logger.get().trace((Object)msg);
    }

    public static void trace(String msg, Throwable t) {
        Logger.get().trace((Object)msg, t);
    }

    public static void debug(String msg) {
        Logger.get().debug((Object)msg);
    }

    public static void debug(String msg, Throwable t) {
        Logger.get().debug((Object)msg, t);
    }

    public static void info(String msg) {
        Logger.get().info((Object)msg);
    }

    public static void info(String msg, Throwable t) {
        Logger.get().info((Object)msg, t);
    }

    public static void warn(String msg) {
        Logger.get().warn((Object)msg);
    }

    public static void warn(String msg, Throwable t) {
        Logger.get().warn((Object)msg, t);
    }

    public static void error(String msg) {
        Logger.get().error((Object)msg);
    }

    public static void error(String msg, Throwable t) {
        Logger.get().error((Object)msg, t);
    }

    public static void fatal(String msg) {
        Logger.get().fatal((Object)msg);
    }

    public static void fatal(String msg, Throwable t) {
        Logger.get().fatal((Object)msg, t);
    }
}

